package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansUtilization(totalCommitment: scala.Option[primitives.GenericString] = None, usedCommitment: scala.Option[primitives.GenericString] = None, unusedCommitment: scala.Option[primitives.GenericString] = None, utilizationPercentage: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization = {
    import SavingsPlansUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization.builder().optionallyWith(totalCommitment.map(value => value: java.lang.String))(_.totalCommitment).optionallyWith(usedCommitment.map(value => value: java.lang.String))(_.usedCommitment).optionallyWith(unusedCommitment.map(value => value: java.lang.String))(_.unusedCommitment).optionallyWith(utilizationPercentage.map(value => value: java.lang.String))(_.utilizationPercentage).build()
  }
  def asReadOnly: SavingsPlansUtilization.ReadOnly = SavingsPlansUtilization.wrap(buildAwsValue())
}
object SavingsPlansUtilization {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansUtilization = SavingsPlansUtilization(totalCommitmentValue.map(value => value), usedCommitmentValue.map(value => value), unusedCommitmentValue.map(value => value), utilizationPercentageValue.map(value => value))
    def totalCommitmentValue: scala.Option[primitives.GenericString]
    def usedCommitmentValue: scala.Option[primitives.GenericString]
    def unusedCommitmentValue: scala.Option[primitives.GenericString]
    def utilizationPercentageValue: scala.Option[primitives.GenericString]
    def totalCommitment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalCommitment", totalCommitmentValue)
    def usedCommitment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("usedCommitment", usedCommitmentValue)
    def unusedCommitment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unusedCommitment", unusedCommitmentValue)
    def utilizationPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("utilizationPercentage", utilizationPercentageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization) extends SavingsPlansUtilization.ReadOnly {
    override def totalCommitmentValue: scala.Option[primitives.GenericString] = scala.Option(impl.totalCommitment()).map(value => value: primitives.GenericString)
    override def usedCommitmentValue: scala.Option[primitives.GenericString] = scala.Option(impl.usedCommitment()).map(value => value: primitives.GenericString)
    override def unusedCommitmentValue: scala.Option[primitives.GenericString] = scala.Option(impl.unusedCommitment()).map(value => value: primitives.GenericString)
    override def utilizationPercentageValue: scala.Option[primitives.GenericString] = scala.Option(impl.utilizationPercentage()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization): ReadOnly = new Wrapper(impl)
}