package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansPurchaseRecommendationMetadata(recommendationId: scala.Option[primitives.GenericString] = None, generationTimestamp: scala.Option[primitives.GenericString] = None, additionalMetadata: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata = {
    import SavingsPlansPurchaseRecommendationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata.builder().optionallyWith(recommendationId.map(value => value: java.lang.String))(_.recommendationId).optionallyWith(generationTimestamp.map(value => value: java.lang.String))(_.generationTimestamp).optionallyWith(additionalMetadata.map(value => value: java.lang.String))(_.additionalMetadata).build()
  }
  def asReadOnly: SavingsPlansPurchaseRecommendationMetadata.ReadOnly = SavingsPlansPurchaseRecommendationMetadata.wrap(buildAwsValue())
}
object SavingsPlansPurchaseRecommendationMetadata {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansPurchaseRecommendationMetadata = SavingsPlansPurchaseRecommendationMetadata(recommendationIdValue.map(value => value), generationTimestampValue.map(value => value), additionalMetadataValue.map(value => value))
    def recommendationIdValue: scala.Option[primitives.GenericString]
    def generationTimestampValue: scala.Option[primitives.GenericString]
    def additionalMetadataValue: scala.Option[primitives.GenericString]
    def recommendationId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recommendationId", recommendationIdValue)
    def generationTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("generationTimestamp", generationTimestampValue)
    def additionalMetadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("additionalMetadata", additionalMetadataValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata) extends SavingsPlansPurchaseRecommendationMetadata.ReadOnly {
    override def recommendationIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.recommendationId()).map(value => value: primitives.GenericString)
    override def generationTimestampValue: scala.Option[primitives.GenericString] = scala.Option(impl.generationTimestamp()).map(value => value: primitives.GenericString)
    override def additionalMetadataValue: scala.Option[primitives.GenericString] = scala.Option(impl.additionalMetadata()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata): ReadOnly = new Wrapper(impl)
}