package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RightsizingRecommendation(accountId: scala.Option[primitives.GenericString] = None, currentInstance: scala.Option[CurrentInstance] = None, rightsizingType: scala.Option[RightsizingType] = None, modifyRecommendationDetail: scala.Option[ModifyRecommendationDetail] = None, terminateRecommendationDetail: scala.Option[TerminateRecommendationDetail] = None, findingReasonCodes: scala.Option[Iterable[FindingReasonCode]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation = {
    import RightsizingRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation.builder().optionallyWith(accountId.map(value => value: java.lang.String))(_.accountId).optionallyWith(currentInstance.map(value => value.buildAwsValue()))(_.currentInstance).optionallyWith(rightsizingType.map(value => value.unwrap))(_.rightsizingType).optionallyWith(modifyRecommendationDetail.map(value => value.buildAwsValue()))(_.modifyRecommendationDetail).optionallyWith(terminateRecommendationDetail.map(value => value.buildAwsValue()))(_.terminateRecommendationDetail).optionallyWith(findingReasonCodes.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.findingReasonCodesWithStrings).build()
  }
  def asReadOnly: RightsizingRecommendation.ReadOnly = RightsizingRecommendation.wrap(buildAwsValue())
}
object RightsizingRecommendation {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RightsizingRecommendation = RightsizingRecommendation(accountIdValue.map(value => value), currentInstanceValue.map(value => value.editable), rightsizingTypeValue.map(value => value), modifyRecommendationDetailValue.map(value => value.editable), terminateRecommendationDetailValue.map(value => value.editable), findingReasonCodesValue.map(value => value))
    def accountIdValue: scala.Option[primitives.GenericString]
    def currentInstanceValue: scala.Option[CurrentInstance.ReadOnly]
    def rightsizingTypeValue: scala.Option[RightsizingType]
    def modifyRecommendationDetailValue: scala.Option[ModifyRecommendationDetail.ReadOnly]
    def terminateRecommendationDetailValue: scala.Option[TerminateRecommendationDetail.ReadOnly]
    def findingReasonCodesValue: scala.Option[List[FindingReasonCode]]
    def accountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountId", accountIdValue)
    def currentInstance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CurrentInstance.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentInstance", currentInstanceValue)
    def rightsizingType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RightsizingType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rightsizingType", rightsizingTypeValue)
    def modifyRecommendationDetail: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ModifyRecommendationDetail.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("modifyRecommendationDetail", modifyRecommendationDetailValue)
    def terminateRecommendationDetail: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TerminateRecommendationDetail.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("terminateRecommendationDetail", terminateRecommendationDetailValue)
    def findingReasonCodes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[FindingReasonCode]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("findingReasonCodes", findingReasonCodesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation) extends RightsizingRecommendation.ReadOnly {
    override def accountIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.accountId()).map(value => value: primitives.GenericString)
    override def currentInstanceValue: scala.Option[CurrentInstance.ReadOnly] = scala.Option(impl.currentInstance()).map(value => CurrentInstance.wrap(value))
    override def rightsizingTypeValue: scala.Option[RightsizingType] = scala.Option(impl.rightsizingType()).map(value => RightsizingType.wrap(value))
    override def modifyRecommendationDetailValue: scala.Option[ModifyRecommendationDetail.ReadOnly] = scala.Option(impl.modifyRecommendationDetail()).map(value => ModifyRecommendationDetail.wrap(value))
    override def terminateRecommendationDetailValue: scala.Option[TerminateRecommendationDetail.ReadOnly] = scala.Option(impl.terminateRecommendationDetail()).map(value => TerminateRecommendationDetail.wrap(value))
    override def findingReasonCodesValue: scala.Option[List[FindingReasonCode]] = scala.Option(impl.findingReasonCodes()).map(value => value.asScala.map { item => 
      FindingReasonCode.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation): ReadOnly = new Wrapper(impl)
}