package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResourceUtilization(ec2ResourceUtilization: scala.Option[EC2ResourceUtilization] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ResourceUtilization = {
    import ResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ResourceUtilization.builder().optionallyWith(ec2ResourceUtilization.map(value => value.buildAwsValue()))(_.ec2ResourceUtilization).build()
  }
  def asReadOnly: ResourceUtilization.ReadOnly = ResourceUtilization.wrap(buildAwsValue())
}
object ResourceUtilization {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ResourceUtilization] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResourceUtilization = ResourceUtilization(ec2ResourceUtilizationValue.map(value => value.editable))
    def ec2ResourceUtilizationValue: scala.Option[EC2ResourceUtilization.ReadOnly]
    def ec2ResourceUtilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EC2ResourceUtilization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2ResourceUtilization", ec2ResourceUtilizationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ResourceUtilization) extends ResourceUtilization.ReadOnly { override def ec2ResourceUtilizationValue: scala.Option[EC2ResourceUtilization.ReadOnly] = scala.Option(impl.ec2ResourceUtilization()).map(value => EC2ResourceUtilization.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ResourceUtilization): ReadOnly = new Wrapper(impl)
}