package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReservationPurchaseRecommendationSummary(totalEstimatedMonthlySavingsAmount: scala.Option[primitives.GenericString] = None, totalEstimatedMonthlySavingsPercentage: scala.Option[primitives.GenericString] = None, currencyCode: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary = {
    import ReservationPurchaseRecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary.builder().optionallyWith(totalEstimatedMonthlySavingsAmount.map(value => value: java.lang.String))(_.totalEstimatedMonthlySavingsAmount).optionallyWith(totalEstimatedMonthlySavingsPercentage.map(value => value: java.lang.String))(_.totalEstimatedMonthlySavingsPercentage).optionallyWith(currencyCode.map(value => value: java.lang.String))(_.currencyCode).build()
  }
  def asReadOnly: ReservationPurchaseRecommendationSummary.ReadOnly = ReservationPurchaseRecommendationSummary.wrap(buildAwsValue())
}
object ReservationPurchaseRecommendationSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReservationPurchaseRecommendationSummary = ReservationPurchaseRecommendationSummary(totalEstimatedMonthlySavingsAmountValue.map(value => value), totalEstimatedMonthlySavingsPercentageValue.map(value => value), currencyCodeValue.map(value => value))
    def totalEstimatedMonthlySavingsAmountValue: scala.Option[primitives.GenericString]
    def totalEstimatedMonthlySavingsPercentageValue: scala.Option[primitives.GenericString]
    def currencyCodeValue: scala.Option[primitives.GenericString]
    def totalEstimatedMonthlySavingsAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalEstimatedMonthlySavingsAmount", totalEstimatedMonthlySavingsAmountValue)
    def totalEstimatedMonthlySavingsPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalEstimatedMonthlySavingsPercentage", totalEstimatedMonthlySavingsPercentageValue)
    def currencyCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary) extends ReservationPurchaseRecommendationSummary.ReadOnly {
    override def totalEstimatedMonthlySavingsAmountValue: scala.Option[primitives.GenericString] = scala.Option(impl.totalEstimatedMonthlySavingsAmount()).map(value => value: primitives.GenericString)
    override def totalEstimatedMonthlySavingsPercentageValue: scala.Option[primitives.GenericString] = scala.Option(impl.totalEstimatedMonthlySavingsPercentage()).map(value => value: primitives.GenericString)
    override def currencyCodeValue: scala.Option[primitives.GenericString] = scala.Option(impl.currencyCode()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary): ReadOnly = new Wrapper(impl)
}