package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReservationPurchaseRecommendationMetadata(recommendationId: scala.Option[primitives.GenericString] = None, generationTimestamp: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata = {
    import ReservationPurchaseRecommendationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata.builder().optionallyWith(recommendationId.map(value => value: java.lang.String))(_.recommendationId).optionallyWith(generationTimestamp.map(value => value: java.lang.String))(_.generationTimestamp).build()
  }
  def asReadOnly: ReservationPurchaseRecommendationMetadata.ReadOnly = ReservationPurchaseRecommendationMetadata.wrap(buildAwsValue())
}
object ReservationPurchaseRecommendationMetadata {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReservationPurchaseRecommendationMetadata = ReservationPurchaseRecommendationMetadata(recommendationIdValue.map(value => value), generationTimestampValue.map(value => value))
    def recommendationIdValue: scala.Option[primitives.GenericString]
    def generationTimestampValue: scala.Option[primitives.GenericString]
    def recommendationId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recommendationId", recommendationIdValue)
    def generationTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("generationTimestamp", generationTimestampValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata) extends ReservationPurchaseRecommendationMetadata.ReadOnly {
    override def recommendationIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.recommendationId()).map(value => value: primitives.GenericString)
    override def generationTimestampValue: scala.Option[primitives.GenericString] = scala.Option(impl.generationTimestamp()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata): ReadOnly = new Wrapper(impl)
}