package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReservationPurchaseRecommendationDetail(accountId: scala.Option[primitives.GenericString] = None, instanceDetails: scala.Option[InstanceDetails] = None, recommendedNumberOfInstancesToPurchase: scala.Option[primitives.GenericString] = None, recommendedNormalizedUnitsToPurchase: scala.Option[primitives.GenericString] = None, minimumNumberOfInstancesUsedPerHour: scala.Option[primitives.GenericString] = None, minimumNormalizedUnitsUsedPerHour: scala.Option[primitives.GenericString] = None, maximumNumberOfInstancesUsedPerHour: scala.Option[primitives.GenericString] = None, maximumNormalizedUnitsUsedPerHour: scala.Option[primitives.GenericString] = None, averageNumberOfInstancesUsedPerHour: scala.Option[primitives.GenericString] = None, averageNormalizedUnitsUsedPerHour: scala.Option[primitives.GenericString] = None, averageUtilization: scala.Option[primitives.GenericString] = None, estimatedBreakEvenInMonths: scala.Option[primitives.GenericString] = None, currencyCode: scala.Option[primitives.GenericString] = None, estimatedMonthlySavingsAmount: scala.Option[primitives.GenericString] = None, estimatedMonthlySavingsPercentage: scala.Option[primitives.GenericString] = None, estimatedMonthlyOnDemandCost: scala.Option[primitives.GenericString] = None, estimatedReservationCostForLookbackPeriod: scala.Option[primitives.GenericString] = None, upfrontCost: scala.Option[primitives.GenericString] = None, recurringStandardMonthlyCost: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail = {
    import ReservationPurchaseRecommendationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail.builder().optionallyWith(accountId.map(value => value: java.lang.String))(_.accountId).optionallyWith(instanceDetails.map(value => value.buildAwsValue()))(_.instanceDetails).optionallyWith(recommendedNumberOfInstancesToPurchase.map(value => value: java.lang.String))(_.recommendedNumberOfInstancesToPurchase).optionallyWith(recommendedNormalizedUnitsToPurchase.map(value => value: java.lang.String))(_.recommendedNormalizedUnitsToPurchase).optionallyWith(minimumNumberOfInstancesUsedPerHour.map(value => value: java.lang.String))(_.minimumNumberOfInstancesUsedPerHour).optionallyWith(minimumNormalizedUnitsUsedPerHour.map(value => value: java.lang.String))(_.minimumNormalizedUnitsUsedPerHour).optionallyWith(maximumNumberOfInstancesUsedPerHour.map(value => value: java.lang.String))(_.maximumNumberOfInstancesUsedPerHour).optionallyWith(maximumNormalizedUnitsUsedPerHour.map(value => value: java.lang.String))(_.maximumNormalizedUnitsUsedPerHour).optionallyWith(averageNumberOfInstancesUsedPerHour.map(value => value: java.lang.String))(_.averageNumberOfInstancesUsedPerHour).optionallyWith(averageNormalizedUnitsUsedPerHour.map(value => value: java.lang.String))(_.averageNormalizedUnitsUsedPerHour).optionallyWith(averageUtilization.map(value => value: java.lang.String))(_.averageUtilization).optionallyWith(estimatedBreakEvenInMonths.map(value => value: java.lang.String))(_.estimatedBreakEvenInMonths).optionallyWith(currencyCode.map(value => value: java.lang.String))(_.currencyCode).optionallyWith(estimatedMonthlySavingsAmount.map(value => value: java.lang.String))(_.estimatedMonthlySavingsAmount).optionallyWith(estimatedMonthlySavingsPercentage.map(value => value: java.lang.String))(_.estimatedMonthlySavingsPercentage).optionallyWith(estimatedMonthlyOnDemandCost.map(value => value: java.lang.String))(_.estimatedMonthlyOnDemandCost).optionallyWith(estimatedReservationCostForLookbackPeriod.map(value => value: java.lang.String))(_.estimatedReservationCostForLookbackPeriod).optionallyWith(upfrontCost.map(value => value: java.lang.String))(_.upfrontCost).optionallyWith(recurringStandardMonthlyCost.map(value => value: java.lang.String))(_.recurringStandardMonthlyCost).build()
  }
  def asReadOnly: ReservationPurchaseRecommendationDetail.ReadOnly = ReservationPurchaseRecommendationDetail.wrap(buildAwsValue())
}
object ReservationPurchaseRecommendationDetail {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReservationPurchaseRecommendationDetail = ReservationPurchaseRecommendationDetail(accountIdValue.map(value => value), instanceDetailsValue.map(value => value.editable), recommendedNumberOfInstancesToPurchaseValue.map(value => value), recommendedNormalizedUnitsToPurchaseValue.map(value => value), minimumNumberOfInstancesUsedPerHourValue.map(value => value), minimumNormalizedUnitsUsedPerHourValue.map(value => value), maximumNumberOfInstancesUsedPerHourValue.map(value => value), maximumNormalizedUnitsUsedPerHourValue.map(value => value), averageNumberOfInstancesUsedPerHourValue.map(value => value), averageNormalizedUnitsUsedPerHourValue.map(value => value), averageUtilizationValue.map(value => value), estimatedBreakEvenInMonthsValue.map(value => value), currencyCodeValue.map(value => value), estimatedMonthlySavingsAmountValue.map(value => value), estimatedMonthlySavingsPercentageValue.map(value => value), estimatedMonthlyOnDemandCostValue.map(value => value), estimatedReservationCostForLookbackPeriodValue.map(value => value), upfrontCostValue.map(value => value), recurringStandardMonthlyCostValue.map(value => value))
    def accountIdValue: scala.Option[primitives.GenericString]
    def instanceDetailsValue: scala.Option[InstanceDetails.ReadOnly]
    def recommendedNumberOfInstancesToPurchaseValue: scala.Option[primitives.GenericString]
    def recommendedNormalizedUnitsToPurchaseValue: scala.Option[primitives.GenericString]
    def minimumNumberOfInstancesUsedPerHourValue: scala.Option[primitives.GenericString]
    def minimumNormalizedUnitsUsedPerHourValue: scala.Option[primitives.GenericString]
    def maximumNumberOfInstancesUsedPerHourValue: scala.Option[primitives.GenericString]
    def maximumNormalizedUnitsUsedPerHourValue: scala.Option[primitives.GenericString]
    def averageNumberOfInstancesUsedPerHourValue: scala.Option[primitives.GenericString]
    def averageNormalizedUnitsUsedPerHourValue: scala.Option[primitives.GenericString]
    def averageUtilizationValue: scala.Option[primitives.GenericString]
    def estimatedBreakEvenInMonthsValue: scala.Option[primitives.GenericString]
    def currencyCodeValue: scala.Option[primitives.GenericString]
    def estimatedMonthlySavingsAmountValue: scala.Option[primitives.GenericString]
    def estimatedMonthlySavingsPercentageValue: scala.Option[primitives.GenericString]
    def estimatedMonthlyOnDemandCostValue: scala.Option[primitives.GenericString]
    def estimatedReservationCostForLookbackPeriodValue: scala.Option[primitives.GenericString]
    def upfrontCostValue: scala.Option[primitives.GenericString]
    def recurringStandardMonthlyCostValue: scala.Option[primitives.GenericString]
    def accountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountId", accountIdValue)
    def instanceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceDetails", instanceDetailsValue)
    def recommendedNumberOfInstancesToPurchase: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recommendedNumberOfInstancesToPurchase", recommendedNumberOfInstancesToPurchaseValue)
    def recommendedNormalizedUnitsToPurchase: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recommendedNormalizedUnitsToPurchase", recommendedNormalizedUnitsToPurchaseValue)
    def minimumNumberOfInstancesUsedPerHour: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumNumberOfInstancesUsedPerHour", minimumNumberOfInstancesUsedPerHourValue)
    def minimumNormalizedUnitsUsedPerHour: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumNormalizedUnitsUsedPerHour", minimumNormalizedUnitsUsedPerHourValue)
    def maximumNumberOfInstancesUsedPerHour: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maximumNumberOfInstancesUsedPerHour", maximumNumberOfInstancesUsedPerHourValue)
    def maximumNormalizedUnitsUsedPerHour: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maximumNormalizedUnitsUsedPerHour", maximumNormalizedUnitsUsedPerHourValue)
    def averageNumberOfInstancesUsedPerHour: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("averageNumberOfInstancesUsedPerHour", averageNumberOfInstancesUsedPerHourValue)
    def averageNormalizedUnitsUsedPerHour: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("averageNormalizedUnitsUsedPerHour", averageNormalizedUnitsUsedPerHourValue)
    def averageUtilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("averageUtilization", averageUtilizationValue)
    def estimatedBreakEvenInMonths: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedBreakEvenInMonths", estimatedBreakEvenInMonthsValue)
    def currencyCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
    def estimatedMonthlySavingsAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedMonthlySavingsAmount", estimatedMonthlySavingsAmountValue)
    def estimatedMonthlySavingsPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedMonthlySavingsPercentage", estimatedMonthlySavingsPercentageValue)
    def estimatedMonthlyOnDemandCost: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedMonthlyOnDemandCost", estimatedMonthlyOnDemandCostValue)
    def estimatedReservationCostForLookbackPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedReservationCostForLookbackPeriod", estimatedReservationCostForLookbackPeriodValue)
    def upfrontCost: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("upfrontCost", upfrontCostValue)
    def recurringStandardMonthlyCost: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recurringStandardMonthlyCost", recurringStandardMonthlyCostValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail) extends ReservationPurchaseRecommendationDetail.ReadOnly {
    override def accountIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.accountId()).map(value => value: primitives.GenericString)
    override def instanceDetailsValue: scala.Option[InstanceDetails.ReadOnly] = scala.Option(impl.instanceDetails()).map(value => InstanceDetails.wrap(value))
    override def recommendedNumberOfInstancesToPurchaseValue: scala.Option[primitives.GenericString] = scala.Option(impl.recommendedNumberOfInstancesToPurchase()).map(value => value: primitives.GenericString)
    override def recommendedNormalizedUnitsToPurchaseValue: scala.Option[primitives.GenericString] = scala.Option(impl.recommendedNormalizedUnitsToPurchase()).map(value => value: primitives.GenericString)
    override def minimumNumberOfInstancesUsedPerHourValue: scala.Option[primitives.GenericString] = scala.Option(impl.minimumNumberOfInstancesUsedPerHour()).map(value => value: primitives.GenericString)
    override def minimumNormalizedUnitsUsedPerHourValue: scala.Option[primitives.GenericString] = scala.Option(impl.minimumNormalizedUnitsUsedPerHour()).map(value => value: primitives.GenericString)
    override def maximumNumberOfInstancesUsedPerHourValue: scala.Option[primitives.GenericString] = scala.Option(impl.maximumNumberOfInstancesUsedPerHour()).map(value => value: primitives.GenericString)
    override def maximumNormalizedUnitsUsedPerHourValue: scala.Option[primitives.GenericString] = scala.Option(impl.maximumNormalizedUnitsUsedPerHour()).map(value => value: primitives.GenericString)
    override def averageNumberOfInstancesUsedPerHourValue: scala.Option[primitives.GenericString] = scala.Option(impl.averageNumberOfInstancesUsedPerHour()).map(value => value: primitives.GenericString)
    override def averageNormalizedUnitsUsedPerHourValue: scala.Option[primitives.GenericString] = scala.Option(impl.averageNormalizedUnitsUsedPerHour()).map(value => value: primitives.GenericString)
    override def averageUtilizationValue: scala.Option[primitives.GenericString] = scala.Option(impl.averageUtilization()).map(value => value: primitives.GenericString)
    override def estimatedBreakEvenInMonthsValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedBreakEvenInMonths()).map(value => value: primitives.GenericString)
    override def currencyCodeValue: scala.Option[primitives.GenericString] = scala.Option(impl.currencyCode()).map(value => value: primitives.GenericString)
    override def estimatedMonthlySavingsAmountValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedMonthlySavingsAmount()).map(value => value: primitives.GenericString)
    override def estimatedMonthlySavingsPercentageValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedMonthlySavingsPercentage()).map(value => value: primitives.GenericString)
    override def estimatedMonthlyOnDemandCostValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedMonthlyOnDemandCost()).map(value => value: primitives.GenericString)
    override def estimatedReservationCostForLookbackPeriodValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedReservationCostForLookbackPeriod()).map(value => value: primitives.GenericString)
    override def upfrontCostValue: scala.Option[primitives.GenericString] = scala.Option(impl.upfrontCost()).map(value => value: primitives.GenericString)
    override def recurringStandardMonthlyCostValue: scala.Option[primitives.GenericString] = scala.Option(impl.recurringStandardMonthlyCost()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail): ReadOnly = new Wrapper(impl)
}