package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReservationCoverageGroup(attributes: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]] = None, coverage: scala.Option[Coverage] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup = {
    import ReservationCoverageGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup.builder().optionallyWith(attributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.attributes).optionallyWith(coverage.map(value => value.buildAwsValue()))(_.coverage).build()
  }
  def asReadOnly: ReservationCoverageGroup.ReadOnly = ReservationCoverageGroup.wrap(buildAwsValue())
}
object ReservationCoverageGroup {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReservationCoverageGroup = ReservationCoverageGroup(attributesValue.map(value => value), coverageValue.map(value => value.editable))
    def attributesValue: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]]
    def coverageValue: scala.Option[Coverage.ReadOnly]
    def attributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.AttributeType, primitives.AttributeValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributes", attributesValue)
    def coverage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Coverage.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("coverage", coverageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup) extends ReservationCoverageGroup.ReadOnly {
    override def attributesValue: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]] = scala.Option(impl.attributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.AttributeType) -> (value: primitives.AttributeValue)
    }).toMap)
    override def coverageValue: scala.Option[Coverage.ReadOnly] = scala.Option(impl.coverage()).map(value => Coverage.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup): ReadOnly = new Wrapper(impl)
}