package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListCostCategoryDefinitionsResponse(costCategoryReferences: scala.Option[Iterable[CostCategoryReference]] = None, nextToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse = {
    import ListCostCategoryDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse.builder().optionallyWith(costCategoryReferences.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.costCategoryReferences).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListCostCategoryDefinitionsResponse.ReadOnly = ListCostCategoryDefinitionsResponse.wrap(buildAwsValue())
}
object ListCostCategoryDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListCostCategoryDefinitionsResponse = ListCostCategoryDefinitionsResponse(costCategoryReferencesValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def costCategoryReferencesValue: scala.Option[List[CostCategoryReference.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextPageToken]
    def costCategoryReferences: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CostCategoryReference.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costCategoryReferences", costCategoryReferencesValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse) extends ListCostCategoryDefinitionsResponse.ReadOnly {
    override def costCategoryReferencesValue: scala.Option[List[CostCategoryReference.ReadOnly]] = scala.Option(impl.costCategoryReferences()).map(value => value.asScala.map { item => 
      CostCategoryReference.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse): ReadOnly = new Wrapper(impl)
}