package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceDetails(ec2InstanceDetails: scala.Option[EC2InstanceDetails] = None, rdsInstanceDetails: scala.Option[RDSInstanceDetails] = None, redshiftInstanceDetails: scala.Option[RedshiftInstanceDetails] = None, elastiCacheInstanceDetails: scala.Option[ElastiCacheInstanceDetails] = None, esInstanceDetails: scala.Option[ESInstanceDetails] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.InstanceDetails = {
    import InstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.InstanceDetails.builder().optionallyWith(ec2InstanceDetails.map(value => value.buildAwsValue()))(_.ec2InstanceDetails).optionallyWith(rdsInstanceDetails.map(value => value.buildAwsValue()))(_.rdsInstanceDetails).optionallyWith(redshiftInstanceDetails.map(value => value.buildAwsValue()))(_.redshiftInstanceDetails).optionallyWith(elastiCacheInstanceDetails.map(value => value.buildAwsValue()))(_.elastiCacheInstanceDetails).optionallyWith(esInstanceDetails.map(value => value.buildAwsValue()))(_.esInstanceDetails).build()
  }
  def asReadOnly: InstanceDetails.ReadOnly = InstanceDetails.wrap(buildAwsValue())
}
object InstanceDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.InstanceDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceDetails = InstanceDetails(ec2InstanceDetailsValue.map(value => value.editable), rdsInstanceDetailsValue.map(value => value.editable), redshiftInstanceDetailsValue.map(value => value.editable), elastiCacheInstanceDetailsValue.map(value => value.editable), esInstanceDetailsValue.map(value => value.editable))
    def ec2InstanceDetailsValue: scala.Option[EC2InstanceDetails.ReadOnly]
    def rdsInstanceDetailsValue: scala.Option[RDSInstanceDetails.ReadOnly]
    def redshiftInstanceDetailsValue: scala.Option[RedshiftInstanceDetails.ReadOnly]
    def elastiCacheInstanceDetailsValue: scala.Option[ElastiCacheInstanceDetails.ReadOnly]
    def esInstanceDetailsValue: scala.Option[ESInstanceDetails.ReadOnly]
    def ec2InstanceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EC2InstanceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2InstanceDetails", ec2InstanceDetailsValue)
    def rdsInstanceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RDSInstanceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rdsInstanceDetails", rdsInstanceDetailsValue)
    def redshiftInstanceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RedshiftInstanceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("redshiftInstanceDetails", redshiftInstanceDetailsValue)
    def elastiCacheInstanceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ElastiCacheInstanceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("elastiCacheInstanceDetails", elastiCacheInstanceDetailsValue)
    def esInstanceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ESInstanceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("esInstanceDetails", esInstanceDetailsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.InstanceDetails) extends InstanceDetails.ReadOnly {
    override def ec2InstanceDetailsValue: scala.Option[EC2InstanceDetails.ReadOnly] = scala.Option(impl.ec2InstanceDetails()).map(value => EC2InstanceDetails.wrap(value))
    override def rdsInstanceDetailsValue: scala.Option[RDSInstanceDetails.ReadOnly] = scala.Option(impl.rdsInstanceDetails()).map(value => RDSInstanceDetails.wrap(value))
    override def redshiftInstanceDetailsValue: scala.Option[RedshiftInstanceDetails.ReadOnly] = scala.Option(impl.redshiftInstanceDetails()).map(value => RedshiftInstanceDetails.wrap(value))
    override def elastiCacheInstanceDetailsValue: scala.Option[ElastiCacheInstanceDetails.ReadOnly] = scala.Option(impl.elastiCacheInstanceDetails()).map(value => ElastiCacheInstanceDetails.wrap(value))
    override def esInstanceDetailsValue: scala.Option[ESInstanceDetails.ReadOnly] = scala.Option(impl.esInstanceDetails()).map(value => ESInstanceDetails.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.InstanceDetails): ReadOnly = new Wrapper(impl)
}