package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Group(keys: scala.Option[Iterable[primitives.Key]] = None, metrics: scala.Option[Map[primitives.MetricName, MetricValue]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.Group = {
    import Group.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Group.builder().optionallyWith(keys.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.keys).optionallyWith(metrics.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.buildAwsValue()
    }).asJava))(_.metrics).build()
  }
  def asReadOnly: Group.ReadOnly = Group.wrap(buildAwsValue())
}
object Group {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.Group] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Group = Group(keysValue.map(value => value), metricsValue.map(value => value.map({
      case (key, value) =>
        key -> value.editable
    })))
    def keysValue: scala.Option[List[primitives.Key]]
    def metricsValue: scala.Option[Map[primitives.MetricName, MetricValue.ReadOnly]]
    def keys: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Key]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keys", keysValue)
    def metrics: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.MetricName, MetricValue.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metrics", metricsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.Group) extends Group.ReadOnly {
    override def keysValue: scala.Option[List[primitives.Key]] = scala.Option(impl.keys()).map(value => value.asScala.map { item => 
      item: primitives.Key
    }.toList)
    override def metricsValue: scala.Option[Map[primitives.MetricName, MetricValue.ReadOnly]] = scala.Option(impl.metrics()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.MetricName) -> MetricValue.wrap(value)
    }).toMap)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.Group): ReadOnly = new Wrapper(impl)
}