package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetSavingsPlansUtilizationResponse(savingsPlansUtilizationsByTime: scala.Option[Iterable[SavingsPlansUtilizationByTime]] = None, total: SavingsPlansUtilizationAggregates) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse = {
    import GetSavingsPlansUtilizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse.builder().optionallyWith(savingsPlansUtilizationsByTime.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.savingsPlansUtilizationsByTime).total(total.buildAwsValue()).build()
  }
  def asReadOnly: GetSavingsPlansUtilizationResponse.ReadOnly = GetSavingsPlansUtilizationResponse.wrap(buildAwsValue())
}
object GetSavingsPlansUtilizationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetSavingsPlansUtilizationResponse = GetSavingsPlansUtilizationResponse(savingsPlansUtilizationsByTimeValue.map(value => value.map { item => 
      item.editable
    }), totalValue.editable)
    def savingsPlansUtilizationsByTimeValue: scala.Option[List[SavingsPlansUtilizationByTime.ReadOnly]]
    def totalValue: SavingsPlansUtilizationAggregates.ReadOnly
    def savingsPlansUtilizationsByTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlansUtilizationByTime.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlansUtilizationsByTime", savingsPlansUtilizationsByTimeValue)
    def total: ZIO[Any, Nothing, SavingsPlansUtilizationAggregates.ReadOnly] = ZIO.succeed(totalValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse) extends GetSavingsPlansUtilizationResponse.ReadOnly {
    override def savingsPlansUtilizationsByTimeValue: scala.Option[List[SavingsPlansUtilizationByTime.ReadOnly]] = scala.Option(impl.savingsPlansUtilizationsByTime()).map(value => value.asScala.map { item => 
      SavingsPlansUtilizationByTime.wrap(item)
    }.toList)
    override def totalValue: SavingsPlansUtilizationAggregates.ReadOnly = SavingsPlansUtilizationAggregates.wrap(impl.total())
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse): ReadOnly = new Wrapper(impl)
}