package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetSavingsPlansUtilizationDetailsRequest(timePeriod: DateInterval, filter: scala.Option[Expression] = None, dataType: scala.Option[Iterable[SavingsPlansDataType]] = None, nextToken: scala.Option[primitives.NextPageToken] = None, maxResults: scala.Option[primitives.MaxResults] = None, sortBy: scala.Option[SortDefinition] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest = {
    import GetSavingsPlansUtilizationDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest.builder().timePeriod(timePeriod.buildAwsValue()).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(dataType.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.dataTypeWithStrings).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy).build()
  }
  def asReadOnly: GetSavingsPlansUtilizationDetailsRequest.ReadOnly = GetSavingsPlansUtilizationDetailsRequest.wrap(buildAwsValue())
}
object GetSavingsPlansUtilizationDetailsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetSavingsPlansUtilizationDetailsRequest = GetSavingsPlansUtilizationDetailsRequest(timePeriodValue.editable, filterValue.map(value => value.editable), dataTypeValue.map(value => value), nextTokenValue.map(value => value), maxResultsValue.map(value => value), sortByValue.map(value => value.editable))
    def timePeriodValue: DateInterval.ReadOnly
    def filterValue: scala.Option[Expression.ReadOnly]
    def dataTypeValue: scala.Option[List[SavingsPlansDataType]]
    def nextTokenValue: scala.Option[primitives.NextPageToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def sortByValue: scala.Option[SortDefinition.ReadOnly]
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def dataType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlansDataType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dataType", dataTypeValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def sortBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SortDefinition.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sortBy", sortByValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest) extends GetSavingsPlansUtilizationDetailsRequest.ReadOnly {
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def dataTypeValue: scala.Option[List[SavingsPlansDataType]] = scala.Option(impl.dataType()).map(value => value.asScala.map { item => 
      SavingsPlansDataType.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextPageToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
    override def sortByValue: scala.Option[SortDefinition.ReadOnly] = scala.Option(impl.sortBy()).map(value => SortDefinition.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest): ReadOnly = new Wrapper(impl)
}