package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRightsizingRecommendationResponse(metadata: scala.Option[RightsizingRecommendationMetadata] = None, summary: scala.Option[RightsizingRecommendationSummary] = None, rightsizingRecommendations: scala.Option[Iterable[RightsizingRecommendation]] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None, configuration: scala.Option[RightsizingRecommendationConfiguration] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse = {
    import GetRightsizingRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse.builder().optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata).optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary).optionallyWith(rightsizingRecommendations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.rightsizingRecommendations).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).optionallyWith(configuration.map(value => value.buildAwsValue()))(_.configuration).build()
  }
  def asReadOnly: GetRightsizingRecommendationResponse.ReadOnly = GetRightsizingRecommendationResponse.wrap(buildAwsValue())
}
object GetRightsizingRecommendationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRightsizingRecommendationResponse = GetRightsizingRecommendationResponse(metadataValue.map(value => value.editable), summaryValue.map(value => value.editable), rightsizingRecommendationsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value), configurationValue.map(value => value.editable))
    def metadataValue: scala.Option[RightsizingRecommendationMetadata.ReadOnly]
    def summaryValue: scala.Option[RightsizingRecommendationSummary.ReadOnly]
    def rightsizingRecommendationsValue: scala.Option[List[RightsizingRecommendation.ReadOnly]]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def configurationValue: scala.Option[RightsizingRecommendationConfiguration.ReadOnly]
    def metadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RightsizingRecommendationMetadata.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metadata", metadataValue)
    def summary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RightsizingRecommendationSummary.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("summary", summaryValue)
    def rightsizingRecommendations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RightsizingRecommendation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rightsizingRecommendations", rightsizingRecommendationsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def configuration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RightsizingRecommendationConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("configuration", configurationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse) extends GetRightsizingRecommendationResponse.ReadOnly {
    override def metadataValue: scala.Option[RightsizingRecommendationMetadata.ReadOnly] = scala.Option(impl.metadata()).map(value => RightsizingRecommendationMetadata.wrap(value))
    override def summaryValue: scala.Option[RightsizingRecommendationSummary.ReadOnly] = scala.Option(impl.summary()).map(value => RightsizingRecommendationSummary.wrap(value))
    override def rightsizingRecommendationsValue: scala.Option[List[RightsizingRecommendation.ReadOnly]] = scala.Option(impl.rightsizingRecommendations()).map(value => value.asScala.map { item => 
      RightsizingRecommendation.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def configurationValue: scala.Option[RightsizingRecommendationConfiguration.ReadOnly] = scala.Option(impl.configuration()).map(value => RightsizingRecommendationConfiguration.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse): ReadOnly = new Wrapper(impl)
}