package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRightsizingRecommendationRequest(filter: scala.Option[Expression] = None, configuration: scala.Option[RightsizingRecommendationConfiguration] = None, service: primitives.GenericString, pageSize: scala.Option[primitives.NonNegativeInteger] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest = {
    import GetRightsizingRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest.builder().optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(configuration.map(value => value.buildAwsValue()))(_.configuration).service(service: java.lang.String).optionallyWith(pageSize.map(value => value: java.lang.Integer))(_.pageSize).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetRightsizingRecommendationRequest.ReadOnly = GetRightsizingRecommendationRequest.wrap(buildAwsValue())
}
object GetRightsizingRecommendationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRightsizingRecommendationRequest = GetRightsizingRecommendationRequest(filterValue.map(value => value.editable), configurationValue.map(value => value.editable), serviceValue, pageSizeValue.map(value => value), nextPageTokenValue.map(value => value))
    def filterValue: scala.Option[Expression.ReadOnly]
    def configurationValue: scala.Option[RightsizingRecommendationConfiguration.ReadOnly]
    def serviceValue: primitives.GenericString
    def pageSizeValue: scala.Option[primitives.NonNegativeInteger]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def configuration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RightsizingRecommendationConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("configuration", configurationValue)
    def service: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(serviceValue)
    def pageSize: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonNegativeInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageSize", pageSizeValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest) extends GetRightsizingRecommendationRequest.ReadOnly {
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def configurationValue: scala.Option[RightsizingRecommendationConfiguration.ReadOnly] = scala.Option(impl.configuration()).map(value => RightsizingRecommendationConfiguration.wrap(value))
    override def serviceValue: primitives.GenericString = impl.service(): primitives.GenericString
    override def pageSizeValue: scala.Option[primitives.NonNegativeInteger] = scala.Option(impl.pageSize()).map(value => value: primitives.NonNegativeInteger)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest): ReadOnly = new Wrapper(impl)
}