package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetReservationPurchaseRecommendationRequest(accountId: scala.Option[primitives.GenericString] = None, service: primitives.GenericString, filter: scala.Option[Expression] = None, accountScope: scala.Option[AccountScope] = None, lookbackPeriodInDays: scala.Option[LookbackPeriodInDays] = None, termInYears: scala.Option[TermInYears] = None, paymentOption: scala.Option[PaymentOption] = None, serviceSpecification: scala.Option[ServiceSpecification] = None, pageSize: scala.Option[primitives.NonNegativeInteger] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest = {
    import GetReservationPurchaseRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest.builder().optionallyWith(accountId.map(value => value: java.lang.String))(_.accountId).service(service: java.lang.String).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(accountScope.map(value => value.unwrap))(_.accountScope).optionallyWith(lookbackPeriodInDays.map(value => value.unwrap))(_.lookbackPeriodInDays).optionallyWith(termInYears.map(value => value.unwrap))(_.termInYears).optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption).optionallyWith(serviceSpecification.map(value => value.buildAwsValue()))(_.serviceSpecification).optionallyWith(pageSize.map(value => value: java.lang.Integer))(_.pageSize).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetReservationPurchaseRecommendationRequest.ReadOnly = GetReservationPurchaseRecommendationRequest.wrap(buildAwsValue())
}
object GetReservationPurchaseRecommendationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetReservationPurchaseRecommendationRequest = GetReservationPurchaseRecommendationRequest(accountIdValue.map(value => value), serviceValue, filterValue.map(value => value.editable), accountScopeValue.map(value => value), lookbackPeriodInDaysValue.map(value => value), termInYearsValue.map(value => value), paymentOptionValue.map(value => value), serviceSpecificationValue.map(value => value.editable), pageSizeValue.map(value => value), nextPageTokenValue.map(value => value))
    def accountIdValue: scala.Option[primitives.GenericString]
    def serviceValue: primitives.GenericString
    def filterValue: scala.Option[Expression.ReadOnly]
    def accountScopeValue: scala.Option[AccountScope]
    def lookbackPeriodInDaysValue: scala.Option[LookbackPeriodInDays]
    def termInYearsValue: scala.Option[TermInYears]
    def paymentOptionValue: scala.Option[PaymentOption]
    def serviceSpecificationValue: scala.Option[ServiceSpecification.ReadOnly]
    def pageSizeValue: scala.Option[primitives.NonNegativeInteger]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def accountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountId", accountIdValue)
    def service: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(serviceValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def accountScope: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccountScope] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountScope", accountScopeValue)
    def lookbackPeriodInDays: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LookbackPeriodInDays] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lookbackPeriodInDays", lookbackPeriodInDaysValue)
    def termInYears: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TermInYears] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("termInYears", termInYearsValue)
    def paymentOption: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PaymentOption] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def serviceSpecification: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ServiceSpecification.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceSpecification", serviceSpecificationValue)
    def pageSize: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonNegativeInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageSize", pageSizeValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest) extends GetReservationPurchaseRecommendationRequest.ReadOnly {
    override def accountIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.accountId()).map(value => value: primitives.GenericString)
    override def serviceValue: primitives.GenericString = impl.service(): primitives.GenericString
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def accountScopeValue: scala.Option[AccountScope] = scala.Option(impl.accountScope()).map(value => AccountScope.wrap(value))
    override def lookbackPeriodInDaysValue: scala.Option[LookbackPeriodInDays] = scala.Option(impl.lookbackPeriodInDays()).map(value => LookbackPeriodInDays.wrap(value))
    override def termInYearsValue: scala.Option[TermInYears] = scala.Option(impl.termInYears()).map(value => TermInYears.wrap(value))
    override def paymentOptionValue: scala.Option[PaymentOption] = scala.Option(impl.paymentOption()).map(value => PaymentOption.wrap(value))
    override def serviceSpecificationValue: scala.Option[ServiceSpecification.ReadOnly] = scala.Option(impl.serviceSpecification()).map(value => ServiceSpecification.wrap(value))
    override def pageSizeValue: scala.Option[primitives.NonNegativeInteger] = scala.Option(impl.pageSize()).map(value => value: primitives.NonNegativeInteger)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest): ReadOnly = new Wrapper(impl)
}