package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetReservationCoverageResponse(coveragesByTime: Iterable[CoverageByTime], total: scala.Option[Coverage] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse = {
    import GetReservationCoverageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse.builder().coveragesByTime(coveragesByTime.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(total.map(value => value.buildAwsValue()))(_.total).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetReservationCoverageResponse.ReadOnly = GetReservationCoverageResponse.wrap(buildAwsValue())
}
object GetReservationCoverageResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetReservationCoverageResponse = GetReservationCoverageResponse(coveragesByTimeValue.map { item => 
      item.editable
    }, totalValue.map(value => value.editable), nextPageTokenValue.map(value => value))
    def coveragesByTimeValue: List[CoverageByTime.ReadOnly]
    def totalValue: scala.Option[Coverage.ReadOnly]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def coveragesByTime: ZIO[Any, Nothing, List[CoverageByTime.ReadOnly]] = ZIO.succeed(coveragesByTimeValue)
    def total: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Coverage.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("total", totalValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse) extends GetReservationCoverageResponse.ReadOnly {
    override def coveragesByTimeValue: List[CoverageByTime.ReadOnly] = impl.coveragesByTime().asScala.map { item => 
      CoverageByTime.wrap(item)
    }.toList
    override def totalValue: scala.Option[Coverage.ReadOnly] = scala.Option(impl.total()).map(value => Coverage.wrap(value))
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse): ReadOnly = new Wrapper(impl)
}