package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetCostAndUsageRequest(timePeriod: DateInterval, granularity: Granularity, filter: scala.Option[Expression] = None, metrics: Iterable[primitives.MetricName], groupBy: scala.Option[Iterable[GroupDefinition]] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest = {
    import GetCostAndUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest.builder().timePeriod(timePeriod.buildAwsValue()).granularity(granularity.unwrap).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).metrics(metrics.map { item => 
      item: java.lang.String
    }.asJavaCollection).optionallyWith(groupBy.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.groupBy).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetCostAndUsageRequest.ReadOnly = GetCostAndUsageRequest.wrap(buildAwsValue())
}
object GetCostAndUsageRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetCostAndUsageRequest = GetCostAndUsageRequest(timePeriodValue.editable, granularityValue, filterValue.map(value => value.editable), metricsValue, groupByValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def timePeriodValue: DateInterval.ReadOnly
    def granularityValue: Granularity
    def filterValue: scala.Option[Expression.ReadOnly]
    def metricsValue: List[primitives.MetricName]
    def groupByValue: scala.Option[List[GroupDefinition.ReadOnly]]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def granularity: ZIO[Any, Nothing, Granularity] = ZIO.succeed(granularityValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def metrics: ZIO[Any, Nothing, List[primitives.MetricName]] = ZIO.succeed(metricsValue)
    def groupBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GroupDefinition.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groupBy", groupByValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest) extends GetCostAndUsageRequest.ReadOnly {
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def granularityValue: Granularity = Granularity.wrap(impl.granularity())
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def metricsValue: List[primitives.MetricName] = impl.metrics().asScala.map { item => 
      item: primitives.MetricName
    }.toList
    override def groupByValue: scala.Option[List[GroupDefinition.ReadOnly]] = scala.Option(impl.groupBy()).map(value => value.asScala.map { item => 
      GroupDefinition.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest): ReadOnly = new Wrapper(impl)
}