package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAnomalyMonitorsResponse(anomalyMonitors: Iterable[AnomalyMonitor], nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse = {
    import GetAnomalyMonitorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse.builder().anomalyMonitors(anomalyMonitors.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetAnomalyMonitorsResponse.ReadOnly = GetAnomalyMonitorsResponse.wrap(buildAwsValue())
}
object GetAnomalyMonitorsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAnomalyMonitorsResponse = GetAnomalyMonitorsResponse(anomalyMonitorsValue.map { item => 
      item.editable
    }, nextPageTokenValue.map(value => value))
    def anomalyMonitorsValue: List[AnomalyMonitor.ReadOnly]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def anomalyMonitors: ZIO[Any, Nothing, List[AnomalyMonitor.ReadOnly]] = ZIO.succeed(anomalyMonitorsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse) extends GetAnomalyMonitorsResponse.ReadOnly {
    override def anomalyMonitorsValue: List[AnomalyMonitor.ReadOnly] = impl.anomalyMonitors().asScala.map { item => 
      AnomalyMonitor.wrap(item)
    }.toList
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse): ReadOnly = new Wrapper(impl)
}