package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAnomaliesResponse(anomalies: Iterable[Anomaly], nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse = {
    import GetAnomaliesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse.builder().anomalies(anomalies.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetAnomaliesResponse.ReadOnly = GetAnomaliesResponse.wrap(buildAwsValue())
}
object GetAnomaliesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAnomaliesResponse = GetAnomaliesResponse(anomaliesValue.map { item => 
      item.editable
    }, nextPageTokenValue.map(value => value))
    def anomaliesValue: List[Anomaly.ReadOnly]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def anomalies: ZIO[Any, Nothing, List[Anomaly.ReadOnly]] = ZIO.succeed(anomaliesValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse) extends GetAnomaliesResponse.ReadOnly {
    override def anomaliesValue: List[Anomaly.ReadOnly] = impl.anomalies().asScala.map { item => 
      Anomaly.wrap(item)
    }.toList
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse): ReadOnly = new Wrapper(impl)
}