package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait FindingReasonCode { def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode }
object FindingReasonCode {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode): FindingReasonCode = value match {
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.CPU_OVER_PROVISIONED =>
      val r = CPU_OVER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.CPU_UNDER_PROVISIONED =>
      val r = CPU_UNDER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.MEMORY_OVER_PROVISIONED =>
      val r = MEMORY_OVER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.MEMORY_UNDER_PROVISIONED =>
      val r = MEMORY_UNDER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.EBS_THROUGHPUT_OVER_PROVISIONED =>
      val r = EBS_THROUGHPUT_OVER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.EBS_THROUGHPUT_UNDER_PROVISIONED =>
      val r = EBS_THROUGHPUT_UNDER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.EBS_IOPS_OVER_PROVISIONED =>
      val r = EBS_IOPS_OVER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.EBS_IOPS_UNDER_PROVISIONED =>
      val r = EBS_IOPS_UNDER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.NETWORK_BANDWIDTH_OVER_PROVISIONED =>
      val r = NETWORK_BANDWIDTH_OVER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.NETWORK_BANDWIDTH_UNDER_PROVISIONED =>
      val r = NETWORK_BANDWIDTH_UNDER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.NETWORK_PPS_OVER_PROVISIONED =>
      val r = NETWORK_PPS_OVER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.NETWORK_PPS_UNDER_PROVISIONED =>
      val r = NETWORK_PPS_UNDER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.DISK_IOPS_OVER_PROVISIONED =>
      val r = DISK_IOPS_OVER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.DISK_IOPS_UNDER_PROVISIONED =>
      val r = DISK_IOPS_UNDER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.DISK_THROUGHPUT_OVER_PROVISIONED =>
      val r = DISK_THROUGHPUT_OVER_PROVISIONED
      r
    case software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.DISK_THROUGHPUT_UNDER_PROVISIONED =>
      val r = DISK_THROUGHPUT_UNDER_PROVISIONED
      r
  }
  case object unknownToSdkVersion extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.UNKNOWN_TO_SDK_VERSION }
  case object CPU_OVER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.CPU_OVER_PROVISIONED }
  case object CPU_UNDER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.CPU_UNDER_PROVISIONED }
  case object MEMORY_OVER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.MEMORY_OVER_PROVISIONED }
  case object MEMORY_UNDER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.MEMORY_UNDER_PROVISIONED }
  case object EBS_THROUGHPUT_OVER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.EBS_THROUGHPUT_OVER_PROVISIONED }
  case object EBS_THROUGHPUT_UNDER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.EBS_THROUGHPUT_UNDER_PROVISIONED }
  case object EBS_IOPS_OVER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.EBS_IOPS_OVER_PROVISIONED }
  case object EBS_IOPS_UNDER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.EBS_IOPS_UNDER_PROVISIONED }
  case object NETWORK_BANDWIDTH_OVER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.NETWORK_BANDWIDTH_OVER_PROVISIONED }
  case object NETWORK_BANDWIDTH_UNDER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.NETWORK_BANDWIDTH_UNDER_PROVISIONED }
  case object NETWORK_PPS_OVER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.NETWORK_PPS_OVER_PROVISIONED }
  case object NETWORK_PPS_UNDER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.NETWORK_PPS_UNDER_PROVISIONED }
  case object DISK_IOPS_OVER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.DISK_IOPS_OVER_PROVISIONED }
  case object DISK_IOPS_UNDER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.DISK_IOPS_UNDER_PROVISIONED }
  case object DISK_THROUGHPUT_OVER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.DISK_THROUGHPUT_OVER_PROVISIONED }
  case object DISK_THROUGHPUT_UNDER_PROVISIONED extends FindingReasonCode { override def unwrap: software.amazon.awssdk.services.costexplorer.model.FindingReasonCode = software.amazon.awssdk.services.costexplorer.model.FindingReasonCode.DISK_THROUGHPUT_UNDER_PROVISIONED }
}