package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeCostCategoryDefinitionRequest(costCategoryArn: primitives.Arn, effectiveOn: scala.Option[primitives.ZonedDateTime] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest = {
    import DescribeCostCategoryDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest.builder().costCategoryArn(costCategoryArn: java.lang.String).optionallyWith(effectiveOn.map(value => value: java.lang.String))(_.effectiveOn).build()
  }
  def asReadOnly: DescribeCostCategoryDefinitionRequest.ReadOnly = DescribeCostCategoryDefinitionRequest.wrap(buildAwsValue())
}
object DescribeCostCategoryDefinitionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeCostCategoryDefinitionRequest = DescribeCostCategoryDefinitionRequest(costCategoryArnValue, effectiveOnValue.map(value => value))
    def costCategoryArnValue: primitives.Arn
    def effectiveOnValue: scala.Option[primitives.ZonedDateTime]
    def costCategoryArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(costCategoryArnValue)
    def effectiveOn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ZonedDateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("effectiveOn", effectiveOnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest) extends DescribeCostCategoryDefinitionRequest.ReadOnly {
    override def costCategoryArnValue: primitives.Arn = impl.costCategoryArn(): primitives.Arn
    override def effectiveOnValue: scala.Option[primitives.ZonedDateTime] = scala.Option(impl.effectiveOn()).map(value => value: primitives.ZonedDateTime)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest): ReadOnly = new Wrapper(impl)
}