package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DateInterval(start: primitives.YearMonthDay, end: primitives.YearMonthDay) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.DateInterval = {
    import DateInterval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DateInterval.builder().start(start: java.lang.String).end(end: java.lang.String).build()
  }
  def asReadOnly: DateInterval.ReadOnly = DateInterval.wrap(buildAwsValue())
}
object DateInterval {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.DateInterval] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DateInterval = DateInterval(startValue, endValue)
    def startValue: primitives.YearMonthDay
    def endValue: primitives.YearMonthDay
    def start: ZIO[Any, Nothing, primitives.YearMonthDay] = ZIO.succeed(startValue)
    def end: ZIO[Any, Nothing, primitives.YearMonthDay] = ZIO.succeed(endValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.DateInterval) extends DateInterval.ReadOnly {
    override def startValue: primitives.YearMonthDay = impl.start(): primitives.YearMonthDay
    override def endValue: primitives.YearMonthDay = impl.end(): primitives.YearMonthDay
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.DateInterval): ReadOnly = new Wrapper(impl)
}