package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateAnomalySubscriptionRequest(anomalySubscription: AnomalySubscription) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest = {
    import CreateAnomalySubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest.builder().anomalySubscription(anomalySubscription.buildAwsValue()).build()
  }
  def asReadOnly: CreateAnomalySubscriptionRequest.ReadOnly = CreateAnomalySubscriptionRequest.wrap(buildAwsValue())
}
object CreateAnomalySubscriptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateAnomalySubscriptionRequest = CreateAnomalySubscriptionRequest(anomalySubscriptionValue.editable)
    def anomalySubscriptionValue: AnomalySubscription.ReadOnly
    def anomalySubscription: ZIO[Any, Nothing, AnomalySubscription.ReadOnly] = ZIO.succeed(anomalySubscriptionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest) extends CreateAnomalySubscriptionRequest.ReadOnly { override def anomalySubscriptionValue: AnomalySubscription.ReadOnly = AnomalySubscription.wrap(impl.anomalySubscription()) }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest): ReadOnly = new Wrapper(impl)
}