package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateAnomalyMonitorRequest(anomalyMonitor: AnomalyMonitor) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest = {
    import CreateAnomalyMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest.builder().anomalyMonitor(anomalyMonitor.buildAwsValue()).build()
  }
  def asReadOnly: CreateAnomalyMonitorRequest.ReadOnly = CreateAnomalyMonitorRequest.wrap(buildAwsValue())
}
object CreateAnomalyMonitorRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateAnomalyMonitorRequest = CreateAnomalyMonitorRequest(anomalyMonitorValue.editable)
    def anomalyMonitorValue: AnomalyMonitor.ReadOnly
    def anomalyMonitor: ZIO[Any, Nothing, AnomalyMonitor.ReadOnly] = ZIO.succeed(anomalyMonitorValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest) extends CreateAnomalyMonitorRequest.ReadOnly { override def anomalyMonitorValue: AnomalyMonitor.ReadOnly = AnomalyMonitor.wrap(impl.anomalyMonitor()) }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest): ReadOnly = new Wrapper(impl)
}