package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CostCategorySplitChargeRule(source: primitives.GenericString, targets: Iterable[primitives.GenericString], method: CostCategorySplitChargeMethod, parameters: scala.Option[Iterable[CostCategorySplitChargeRuleParameter]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule = {
    import CostCategorySplitChargeRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule.builder().source(source: java.lang.String).targets(targets.map { item => 
      item: java.lang.String
    }.asJavaCollection).method(method.unwrap).optionallyWith(parameters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.parameters).build()
  }
  def asReadOnly: CostCategorySplitChargeRule.ReadOnly = CostCategorySplitChargeRule.wrap(buildAwsValue())
}
object CostCategorySplitChargeRule {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CostCategorySplitChargeRule = CostCategorySplitChargeRule(sourceValue, targetsValue, methodValue, parametersValue.map(value => value.map { item => 
      item.editable
    }))
    def sourceValue: primitives.GenericString
    def targetsValue: List[primitives.GenericString]
    def methodValue: CostCategorySplitChargeMethod
    def parametersValue: scala.Option[List[CostCategorySplitChargeRuleParameter.ReadOnly]]
    def source: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(sourceValue)
    def targets: ZIO[Any, Nothing, List[primitives.GenericString]] = ZIO.succeed(targetsValue)
    def method: ZIO[Any, Nothing, CostCategorySplitChargeMethod] = ZIO.succeed(methodValue)
    def parameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CostCategorySplitChargeRuleParameter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameters", parametersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule) extends CostCategorySplitChargeRule.ReadOnly {
    override def sourceValue: primitives.GenericString = impl.source(): primitives.GenericString
    override def targetsValue: List[primitives.GenericString] = impl.targets().asScala.map { item => 
      item: primitives.GenericString
    }.toList
    override def methodValue: CostCategorySplitChargeMethod = CostCategorySplitChargeMethod.wrap(impl.method())
    override def parametersValue: scala.Option[List[CostCategorySplitChargeRuleParameter.ReadOnly]] = scala.Option(impl.parameters()).map(value => value.asScala.map { item => 
      CostCategorySplitChargeRuleParameter.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule): ReadOnly = new Wrapper(impl)
}