package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CostCategoryRule(value: scala.Option[primitives.CostCategoryValue] = None, rule: scala.Option[Expression] = None, inheritedValue: scala.Option[CostCategoryInheritedValueDimension] = None, `type`: scala.Option[CostCategoryRuleType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CostCategoryRule = {
    import CostCategoryRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryRule.builder().optionallyWith(value.map(value => value: java.lang.String))(_.value).optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule).optionallyWith(inheritedValue.map(value => value.buildAwsValue()))(_.inheritedValue).optionallyWith(`type`.map(value => value.unwrap))(_.`type`).build()
  }
  def asReadOnly: CostCategoryRule.ReadOnly = CostCategoryRule.wrap(buildAwsValue())
}
object CostCategoryRule {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CostCategoryRule] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CostCategoryRule = CostCategoryRule(valueValue.map(value => value), ruleValue.map(value => value.editable), inheritedValueValue.map(value => value.editable), typeValue.map(value => value))
    def valueValue: scala.Option[primitives.CostCategoryValue]
    def ruleValue: scala.Option[Expression.ReadOnly]
    def inheritedValueValue: scala.Option[CostCategoryInheritedValueDimension.ReadOnly]
    def typeValue: scala.Option[CostCategoryRuleType]
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CostCategoryValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
    def rule: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rule", ruleValue)
    def inheritedValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostCategoryInheritedValueDimension.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inheritedValue", inheritedValueValue)
    def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostCategoryRuleType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryRule) extends CostCategoryRule.ReadOnly {
    override def valueValue: scala.Option[primitives.CostCategoryValue] = scala.Option(impl.value()).map(value => value: primitives.CostCategoryValue)
    override def ruleValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.rule()).map(value => Expression.wrap(value))
    override def inheritedValueValue: scala.Option[CostCategoryInheritedValueDimension.ReadOnly] = scala.Option(impl.inheritedValue()).map(value => CostCategoryInheritedValueDimension.wrap(value))
    override def typeValue: scala.Option[CostCategoryRuleType] = scala.Option(impl.`type`()).map(value => CostCategoryRuleType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryRule): ReadOnly = new Wrapper(impl)
}