package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CostCategoryReference(costCategoryArn: scala.Option[primitives.Arn] = None, name: scala.Option[primitives.CostCategoryName] = None, effectiveStart: scala.Option[primitives.ZonedDateTime] = None, effectiveEnd: scala.Option[primitives.ZonedDateTime] = None, numberOfRules: scala.Option[primitives.NonNegativeInteger] = None, processingStatus: scala.Option[Iterable[CostCategoryProcessingStatus]] = None, values: scala.Option[Iterable[primitives.CostCategoryValue]] = None, defaultValue: scala.Option[primitives.CostCategoryValue] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CostCategoryReference = {
    import CostCategoryReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryReference.builder().optionallyWith(costCategoryArn.map(value => value: java.lang.String))(_.costCategoryArn).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(effectiveStart.map(value => value: java.lang.String))(_.effectiveStart).optionallyWith(effectiveEnd.map(value => value: java.lang.String))(_.effectiveEnd).optionallyWith(numberOfRules.map(value => value: java.lang.Integer))(_.numberOfRules).optionallyWith(processingStatus.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.processingStatus).optionallyWith(values.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.values).optionallyWith(defaultValue.map(value => value: java.lang.String))(_.defaultValue).build()
  }
  def asReadOnly: CostCategoryReference.ReadOnly = CostCategoryReference.wrap(buildAwsValue())
}
object CostCategoryReference {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CostCategoryReference] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CostCategoryReference = CostCategoryReference(costCategoryArnValue.map(value => value), nameValue.map(value => value), effectiveStartValue.map(value => value), effectiveEndValue.map(value => value), numberOfRulesValue.map(value => value), processingStatusValue.map(value => value.map { item => 
      item.editable
    }), valuesValue.map(value => value), defaultValueValue.map(value => value))
    def costCategoryArnValue: scala.Option[primitives.Arn]
    def nameValue: scala.Option[primitives.CostCategoryName]
    def effectiveStartValue: scala.Option[primitives.ZonedDateTime]
    def effectiveEndValue: scala.Option[primitives.ZonedDateTime]
    def numberOfRulesValue: scala.Option[primitives.NonNegativeInteger]
    def processingStatusValue: scala.Option[List[CostCategoryProcessingStatus.ReadOnly]]
    def valuesValue: scala.Option[List[primitives.CostCategoryValue]]
    def defaultValueValue: scala.Option[primitives.CostCategoryValue]
    def costCategoryArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Arn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costCategoryArn", costCategoryArnValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CostCategoryName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def effectiveStart: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ZonedDateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("effectiveStart", effectiveStartValue)
    def effectiveEnd: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ZonedDateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("effectiveEnd", effectiveEndValue)
    def numberOfRules: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonNegativeInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("numberOfRules", numberOfRulesValue)
    def processingStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CostCategoryProcessingStatus.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("processingStatus", processingStatusValue)
    def values: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.CostCategoryValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("values", valuesValue)
    def defaultValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CostCategoryValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultValue", defaultValueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryReference) extends CostCategoryReference.ReadOnly {
    override def costCategoryArnValue: scala.Option[primitives.Arn] = scala.Option(impl.costCategoryArn()).map(value => value: primitives.Arn)
    override def nameValue: scala.Option[primitives.CostCategoryName] = scala.Option(impl.name()).map(value => value: primitives.CostCategoryName)
    override def effectiveStartValue: scala.Option[primitives.ZonedDateTime] = scala.Option(impl.effectiveStart()).map(value => value: primitives.ZonedDateTime)
    override def effectiveEndValue: scala.Option[primitives.ZonedDateTime] = scala.Option(impl.effectiveEnd()).map(value => value: primitives.ZonedDateTime)
    override def numberOfRulesValue: scala.Option[primitives.NonNegativeInteger] = scala.Option(impl.numberOfRules()).map(value => value: primitives.NonNegativeInteger)
    override def processingStatusValue: scala.Option[List[CostCategoryProcessingStatus.ReadOnly]] = scala.Option(impl.processingStatus()).map(value => value.asScala.map { item => 
      CostCategoryProcessingStatus.wrap(item)
    }.toList)
    override def valuesValue: scala.Option[List[primitives.CostCategoryValue]] = scala.Option(impl.values()).map(value => value.asScala.map { item => 
      item: primitives.CostCategoryValue
    }.toList)
    override def defaultValueValue: scala.Option[primitives.CostCategoryValue] = scala.Option(impl.defaultValue()).map(value => value: primitives.CostCategoryValue)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryReference): ReadOnly = new Wrapper(impl)
}