package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AnomalyScore(maxScore: primitives.GenericDouble, currentScore: primitives.GenericDouble) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.AnomalyScore = {
    import AnomalyScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.AnomalyScore.builder().maxScore(maxScore: java.lang.Double).currentScore(currentScore: java.lang.Double).build()
  }
  def asReadOnly: AnomalyScore.ReadOnly = AnomalyScore.wrap(buildAwsValue())
}
object AnomalyScore {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.AnomalyScore] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AnomalyScore = AnomalyScore(maxScoreValue, currentScoreValue)
    def maxScoreValue: primitives.GenericDouble
    def currentScoreValue: primitives.GenericDouble
    def maxScore: ZIO[Any, Nothing, primitives.GenericDouble] = ZIO.succeed(maxScoreValue)
    def currentScore: ZIO[Any, Nothing, primitives.GenericDouble] = ZIO.succeed(currentScoreValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.AnomalyScore) extends AnomalyScore.ReadOnly {
    override def maxScoreValue: primitives.GenericDouble = impl.maxScore(): primitives.GenericDouble
    override def currentScoreValue: primitives.GenericDouble = impl.currentScore(): primitives.GenericDouble
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.AnomalyScore): ReadOnly = new Wrapper(impl)
}