package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait AccountScope { def unwrap: software.amazon.awssdk.services.costexplorer.model.AccountScope }
object AccountScope {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.AccountScope): AccountScope = value match {
    case software.amazon.awssdk.services.costexplorer.model.AccountScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.AccountScope.PAYER =>
      val r = PAYER
      r
    case software.amazon.awssdk.services.costexplorer.model.AccountScope.LINKED =>
      val r = LINKED
      r
  }
  case object unknownToSdkVersion extends AccountScope { override def unwrap: software.amazon.awssdk.services.costexplorer.model.AccountScope = software.amazon.awssdk.services.costexplorer.model.AccountScope.UNKNOWN_TO_SDK_VERSION }
  case object PAYER extends AccountScope { override def unwrap: software.amazon.awssdk.services.costexplorer.model.AccountScope = software.amazon.awssdk.services.costexplorer.model.AccountScope.PAYER }
  case object LINKED extends AccountScope { override def unwrap: software.amazon.awssdk.services.costexplorer.model.AccountScope = software.amazon.awssdk.services.costexplorer.model.AccountScope.LINKED }
}