package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansUtilizationDetail(savingsPlanArn: scala.Option[primitives.SavingsPlanArn] = None, attributes: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]] = None, utilization: scala.Option[SavingsPlansUtilization] = None, savings: scala.Option[SavingsPlansSavings] = None, amortizedCommitment: scala.Option[SavingsPlansAmortizedCommitment] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail = {
    import SavingsPlansUtilizationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail.builder().optionallyWith(savingsPlanArn.map(value => value: java.lang.String))(_.savingsPlanArn).optionallyWith(attributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.attributes).optionallyWith(utilization.map(value => value.buildAwsValue()))(_.utilization).optionallyWith(savings.map(value => value.buildAwsValue()))(_.savings).optionallyWith(amortizedCommitment.map(value => value.buildAwsValue()))(_.amortizedCommitment).build()
  }
  def asReadOnly: SavingsPlansUtilizationDetail.ReadOnly = SavingsPlansUtilizationDetail.wrap(buildAwsValue())
}
object SavingsPlansUtilizationDetail {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansUtilizationDetail = SavingsPlansUtilizationDetail(savingsPlanArnValue.map(value => value), attributesValue.map(value => value), utilizationValue.map(value => value.editable), savingsValue.map(value => value.editable), amortizedCommitmentValue.map(value => value.editable))
    def savingsPlanArnValue: scala.Option[primitives.SavingsPlanArn]
    def attributesValue: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]]
    def utilizationValue: scala.Option[SavingsPlansUtilization.ReadOnly]
    def savingsValue: scala.Option[SavingsPlansSavings.ReadOnly]
    def amortizedCommitmentValue: scala.Option[SavingsPlansAmortizedCommitment.ReadOnly]
    def savingsPlanArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanArn", savingsPlanArnValue)
    def attributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.AttributeType, primitives.AttributeValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributes", attributesValue)
    def utilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansUtilization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("utilization", utilizationValue)
    def savings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansSavings.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savings", savingsValue)
    def amortizedCommitment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansAmortizedCommitment.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amortizedCommitment", amortizedCommitmentValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail) extends SavingsPlansUtilizationDetail.ReadOnly {
    override def savingsPlanArnValue: scala.Option[primitives.SavingsPlanArn] = scala.Option(impl.savingsPlanArn()).map(value => value: primitives.SavingsPlanArn)
    override def attributesValue: scala.Option[Map[primitives.AttributeType, primitives.AttributeValue]] = scala.Option(impl.attributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.AttributeType) -> (value: primitives.AttributeValue)
    }).toMap)
    override def utilizationValue: scala.Option[SavingsPlansUtilization.ReadOnly] = scala.Option(impl.utilization()).map(value => SavingsPlansUtilization.wrap(value))
    override def savingsValue: scala.Option[SavingsPlansSavings.ReadOnly] = scala.Option(impl.savings()).map(value => SavingsPlansSavings.wrap(value))
    override def amortizedCommitmentValue: scala.Option[SavingsPlansAmortizedCommitment.ReadOnly] = scala.Option(impl.amortizedCommitment()).map(value => SavingsPlansAmortizedCommitment.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail): ReadOnly = new Wrapper(impl)
}