package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EBSResourceUtilization(ebsReadOpsPerSecond: scala.Option[primitives.GenericString] = None, ebsWriteOpsPerSecond: scala.Option[primitives.GenericString] = None, ebsReadBytesPerSecond: scala.Option[primitives.GenericString] = None, ebsWriteBytesPerSecond: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization = {
    import EBSResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization.builder().optionallyWith(ebsReadOpsPerSecond.map(value => value: java.lang.String))(_.ebsReadOpsPerSecond).optionallyWith(ebsWriteOpsPerSecond.map(value => value: java.lang.String))(_.ebsWriteOpsPerSecond).optionallyWith(ebsReadBytesPerSecond.map(value => value: java.lang.String))(_.ebsReadBytesPerSecond).optionallyWith(ebsWriteBytesPerSecond.map(value => value: java.lang.String))(_.ebsWriteBytesPerSecond).build()
  }
  def asReadOnly: EBSResourceUtilization.ReadOnly = EBSResourceUtilization.wrap(buildAwsValue())
}
object EBSResourceUtilization {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EBSResourceUtilization = EBSResourceUtilization(ebsReadOpsPerSecondValue.map(value => value), ebsWriteOpsPerSecondValue.map(value => value), ebsReadBytesPerSecondValue.map(value => value), ebsWriteBytesPerSecondValue.map(value => value))
    def ebsReadOpsPerSecondValue: scala.Option[primitives.GenericString]
    def ebsWriteOpsPerSecondValue: scala.Option[primitives.GenericString]
    def ebsReadBytesPerSecondValue: scala.Option[primitives.GenericString]
    def ebsWriteBytesPerSecondValue: scala.Option[primitives.GenericString]
    def ebsReadOpsPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ebsReadOpsPerSecond", ebsReadOpsPerSecondValue)
    def ebsWriteOpsPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ebsWriteOpsPerSecond", ebsWriteOpsPerSecondValue)
    def ebsReadBytesPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ebsReadBytesPerSecond", ebsReadBytesPerSecondValue)
    def ebsWriteBytesPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ebsWriteBytesPerSecond", ebsWriteBytesPerSecondValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization) extends EBSResourceUtilization.ReadOnly {
    override def ebsReadOpsPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.ebsReadOpsPerSecond()).map(value => value: primitives.GenericString)
    override def ebsWriteOpsPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.ebsWriteOpsPerSecond()).map(value => value: primitives.GenericString)
    override def ebsReadBytesPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.ebsReadBytesPerSecond()).map(value => value: primitives.GenericString)
    override def ebsWriteBytesPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.ebsWriteBytesPerSecond()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization): ReadOnly = new Wrapper(impl)
}