package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SubscriberType { def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberType }
object SubscriberType {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.SubscriberType): SubscriberType = value match {
    case software.amazon.awssdk.services.costexplorer.model.SubscriberType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.SubscriberType.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.costexplorer.model.SubscriberType.SNS =>
      val r = SNS
      r
  }
  case object unknownToSdkVersion extends SubscriberType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberType = software.amazon.awssdk.services.costexplorer.model.SubscriberType.UNKNOWN_TO_SDK_VERSION }
  case object EMAIL extends SubscriberType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberType = software.amazon.awssdk.services.costexplorer.model.SubscriberType.EMAIL }
  case object SNS extends SubscriberType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberType = software.amazon.awssdk.services.costexplorer.model.SubscriberType.SNS }
}