package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UtilizationByTime(
    timePeriod: Option[io.github.vigoo.zioaws.costexplorer.model.DateInterval] =
      None,
    groups: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup
    ]] = None,
    total: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.UtilizationByTime = {
    import UtilizationByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UtilizationByTime
      .builder()
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime
      .wrap(buildAwsValue())
}
object UtilizationByTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.UtilizationByTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime =
      io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime(
        timePeriodValue.map(value => value.editable),
        groupsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        totalValue.map(value => value.editable)
      )
    def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ]
    def groupsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup.ReadOnly
    ]]
    def totalValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ]
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def groups: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groupsValue)
    def total: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ] = AwsError.unwrapOptionField("total", totalValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.UtilizationByTime
  ) extends io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime.ReadOnly {
    override def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = scala
      .Option(impl.timePeriod())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.DateInterval.wrap(value)
      )
    override def groupsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup.ReadOnly
    ]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup
            .wrap(item)
        }.toList
      )
    override def totalValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ] = scala
      .Option(impl.total())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.UtilizationByTime
  ): io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime.ReadOnly =
    new Wrapper(impl)
}
