package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  AttributeValue,
  AttributeType,
  SavingsPlanArn
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansUtilizationDetail(
    savingsPlanArn: Option[SavingsPlanArn] = None,
    attributes: Option[Map[AttributeType, AttributeValue]] = None,
    utilization: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization
    ] = None,
    savings: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings
    ] = None,
    amortizedCommitment: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail = {
    import SavingsPlansUtilizationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail
      .builder()
      .optionallyWith(savingsPlanArn.map(value => value: java.lang.String))(
        _.savingsPlanArn
      )
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(utilization.map(value => value.buildAwsValue()))(
        _.utilization
      )
      .optionallyWith(savings.map(value => value.buildAwsValue()))(_.savings)
      .optionallyWith(amortizedCommitment.map(value => value.buildAwsValue()))(
        _.amortizedCommitment
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail
      .wrap(buildAwsValue())
}
object SavingsPlansUtilizationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail(
        savingsPlanArnValue.map(value => value),
        attributesValue.map(value => value),
        utilizationValue.map(value => value.editable),
        savingsValue.map(value => value.editable),
        amortizedCommitmentValue.map(value => value.editable)
      )
    def savingsPlanArnValue: Option[SavingsPlanArn]
    def attributesValue: Option[Map[AttributeType, AttributeValue]]
    def utilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly
    ]
    def savingsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly
    ]
    def amortizedCommitmentValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly
    ]
    def savingsPlanArn: ZIO[Any, AwsError, SavingsPlanArn] =
      AwsError.unwrapOptionField("savingsPlanArn", savingsPlanArnValue)
    def attributes: ZIO[Any, AwsError, Map[AttributeType, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributesValue)
    def utilization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly
    ] = AwsError.unwrapOptionField("utilization", utilizationValue)
    def savings: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly
    ] = AwsError.unwrapOptionField("savings", savingsValue)
    def amortizedCommitment: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amortizedCommitment",
      amortizedCommitmentValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly {
    override def savingsPlanArnValue: Option[SavingsPlanArn] =
      scala.Option(impl.savingsPlanArn()).map(value => value: SavingsPlanArn)
    override def attributesValue: Option[Map[AttributeType, AttributeValue]] =
      scala
        .Option(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: AttributeType) -> (value: AttributeValue)
            })
            .toMap
        )
    override def utilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly
    ] = scala
      .Option(impl.utilization())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization
          .wrap(value)
      )
    override def savingsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly
    ] = scala
      .Option(impl.savings())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings
          .wrap(value)
      )
    override def amortizedCommitmentValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly
    ] = scala
      .Option(impl.amortizedCommitment())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly =
    new Wrapper(impl)
}
