package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait PlatformDifference {
  def unwrap
      : software.amazon.awssdk.services.costexplorer.model.PlatformDifference
}
object PlatformDifference {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.PlatformDifference
  ): io.github.vigoo.zioaws.costexplorer.model.PlatformDifference =
    value match {
      case software.amazon.awssdk.services.costexplorer.model.PlatformDifference.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.costexplorer.model.PlatformDifference.HYPERVISOR =>
        val r = HYPERVISOR
        r
      case software.amazon.awssdk.services.costexplorer.model.PlatformDifference.NETWORK_INTERFACE =>
        val r = NETWORK_INTERFACE
        r
      case software.amazon.awssdk.services.costexplorer.model.PlatformDifference.STORAGE_INTERFACE =>
        val r = STORAGE_INTERFACE
        r
      case software.amazon.awssdk.services.costexplorer.model.PlatformDifference.INSTANCE_STORE_AVAILABILITY =>
        val r = INSTANCE_STORE_AVAILABILITY
        r
      case software.amazon.awssdk.services.costexplorer.model.PlatformDifference.VIRTUALIZATION_TYPE =>
        val r = VIRTUALIZATION_TYPE
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PlatformDifference =
      software.amazon.awssdk.services.costexplorer.model.PlatformDifference.UNKNOWN_TO_SDK_VERSION
  }
  case object HYPERVISOR
      extends io.github.vigoo.zioaws.costexplorer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PlatformDifference =
      software.amazon.awssdk.services.costexplorer.model.PlatformDifference.HYPERVISOR
  }
  case object NETWORK_INTERFACE
      extends io.github.vigoo.zioaws.costexplorer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PlatformDifference =
      software.amazon.awssdk.services.costexplorer.model.PlatformDifference.NETWORK_INTERFACE
  }
  case object STORAGE_INTERFACE
      extends io.github.vigoo.zioaws.costexplorer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PlatformDifference =
      software.amazon.awssdk.services.costexplorer.model.PlatformDifference.STORAGE_INTERFACE
  }
  case object INSTANCE_STORE_AVAILABILITY
      extends io.github.vigoo.zioaws.costexplorer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PlatformDifference =
      software.amazon.awssdk.services.costexplorer.model.PlatformDifference.INSTANCE_STORE_AVAILABILITY
  }
  case object VIRTUALIZATION_TYPE
      extends io.github.vigoo.zioaws.costexplorer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PlatformDifference =
      software.amazon.awssdk.services.costexplorer.model.PlatformDifference.VIRTUALIZATION_TYPE
  }
}
