package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceDetails(
    ec2InstanceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails
    ] = None,
    rdsInstanceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails
    ] = None,
    redshiftInstanceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.RedshiftInstanceDetails
    ] = None,
    elastiCacheInstanceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.ElastiCacheInstanceDetails
    ] = None,
    esInstanceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.InstanceDetails = {
    import InstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.InstanceDetails
      .builder()
      .optionallyWith(ec2InstanceDetails.map(value => value.buildAwsValue()))(
        _.ec2InstanceDetails
      )
      .optionallyWith(rdsInstanceDetails.map(value => value.buildAwsValue()))(
        _.rdsInstanceDetails
      )
      .optionallyWith(
        redshiftInstanceDetails.map(value => value.buildAwsValue())
      )(_.redshiftInstanceDetails)
      .optionallyWith(
        elastiCacheInstanceDetails.map(value => value.buildAwsValue())
      )(_.elastiCacheInstanceDetails)
      .optionallyWith(esInstanceDetails.map(value => value.buildAwsValue()))(
        _.esInstanceDetails
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.InstanceDetails.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.InstanceDetails
      .wrap(buildAwsValue())
}
object InstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.InstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.InstanceDetails =
      io.github.vigoo.zioaws.costexplorer.model.InstanceDetails(
        ec2InstanceDetailsValue.map(value => value.editable),
        rdsInstanceDetailsValue.map(value => value.editable),
        redshiftInstanceDetailsValue.map(value => value.editable),
        elastiCacheInstanceDetailsValue.map(value => value.editable),
        esInstanceDetailsValue.map(value => value.editable)
      )
    def ec2InstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails.ReadOnly
    ]
    def rdsInstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails.ReadOnly
    ]
    def redshiftInstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RedshiftInstanceDetails.ReadOnly
    ]
    def elastiCacheInstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ElastiCacheInstanceDetails.ReadOnly
    ]
    def esInstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails.ReadOnly
    ]
    def ec2InstanceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("ec2InstanceDetails", ec2InstanceDetailsValue)
    def rdsInstanceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("rdsInstanceDetails", rdsInstanceDetailsValue)
    def redshiftInstanceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.RedshiftInstanceDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftInstanceDetails",
      redshiftInstanceDetailsValue
    )
    def elastiCacheInstanceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ElastiCacheInstanceDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elastiCacheInstanceDetails",
      elastiCacheInstanceDetailsValue
    )
    def esInstanceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("esInstanceDetails", esInstanceDetailsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.InstanceDetails
  ) extends io.github.vigoo.zioaws.costexplorer.model.InstanceDetails.ReadOnly {
    override def ec2InstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails.ReadOnly
    ] = scala
      .Option(impl.ec2InstanceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails.wrap(value)
      )
    override def rdsInstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails.ReadOnly
    ] = scala
      .Option(impl.rdsInstanceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails.wrap(value)
      )
    override def redshiftInstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RedshiftInstanceDetails.ReadOnly
    ] = scala
      .Option(impl.redshiftInstanceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.RedshiftInstanceDetails
          .wrap(value)
      )
    override def elastiCacheInstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ElastiCacheInstanceDetails.ReadOnly
    ] = scala
      .Option(impl.elastiCacheInstanceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ElastiCacheInstanceDetails
          .wrap(value)
      )
    override def esInstanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails.ReadOnly
    ] = scala
      .Option(impl.esInstanceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.InstanceDetails
  ): io.github.vigoo.zioaws.costexplorer.model.InstanceDetails.ReadOnly =
    new Wrapper(impl)
}
