package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  MaxResults,
  NextPageToken
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSavingsPlansUtilizationDetailsRequest(
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    dataType: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType]
    ] = None,
    nextToken: Option[NextPageToken] = None,
    maxResults: Option[MaxResults] = None,
    sortBy: Option[io.github.vigoo.zioaws.costexplorer.model.SortDefinition] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest = {
    import GetSavingsPlansUtilizationDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
      .builder()
      .timePeriod(timePeriod.buildAwsValue())
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        dataType.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.dataTypeWithStrings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
      .wrap(buildAwsValue())
}
object GetSavingsPlansUtilizationDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .GetSavingsPlansUtilizationDetailsRequest(
          timePeriodValue.editable,
          filterValue.map(value => value.editable),
          dataTypeValue.map(value => value),
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value),
          sortByValue.map(value => value.editable)
        )
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def dataTypeValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType]
    ]
    def nextTokenValue: Option[NextPageToken]
    def maxResultsValue: Option[MaxResults]
    def sortByValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ]
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def dataType: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType
    ]] = AwsError.unwrapOptionField("dataType", dataTypeValue)
    def nextToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def sortBy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortByValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest.ReadOnly {
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def dataTypeValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType]
    ] = scala
      .Option(impl.dataType())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextToken()).map(value => value: NextPageToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def sortByValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ] = scala
      .Option(impl.sortBy())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SortDefinition.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
