package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EC2ResourceUtilization(
    maxCpuUtilizationPercentage: Option[GenericString] = None,
    maxMemoryUtilizationPercentage: Option[GenericString] = None,
    maxStorageUtilizationPercentage: Option[GenericString] = None,
    ebsResourceUtilization: Option[
      io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization
    ] = None,
    diskResourceUtilization: Option[
      io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization
    ] = None,
    networkResourceUtilization: Option[
      io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization = {
    import EC2ResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization
      .builder()
      .optionallyWith(
        maxCpuUtilizationPercentage.map(value => value: java.lang.String)
      )(_.maxCpuUtilizationPercentage)
      .optionallyWith(
        maxMemoryUtilizationPercentage.map(value => value: java.lang.String)
      )(_.maxMemoryUtilizationPercentage)
      .optionallyWith(
        maxStorageUtilizationPercentage.map(value => value: java.lang.String)
      )(_.maxStorageUtilizationPercentage)
      .optionallyWith(
        ebsResourceUtilization.map(value => value.buildAwsValue())
      )(_.ebsResourceUtilization)
      .optionallyWith(
        diskResourceUtilization.map(value => value.buildAwsValue())
      )(_.diskResourceUtilization)
      .optionallyWith(
        networkResourceUtilization.map(value => value.buildAwsValue())
      )(_.networkResourceUtilization)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization
      .wrap(buildAwsValue())
}
object EC2ResourceUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization =
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization(
        maxCpuUtilizationPercentageValue.map(value => value),
        maxMemoryUtilizationPercentageValue.map(value => value),
        maxStorageUtilizationPercentageValue.map(value => value),
        ebsResourceUtilizationValue.map(value => value.editable),
        diskResourceUtilizationValue.map(value => value.editable),
        networkResourceUtilizationValue.map(value => value.editable)
      )
    def maxCpuUtilizationPercentageValue: Option[GenericString]
    def maxMemoryUtilizationPercentageValue: Option[GenericString]
    def maxStorageUtilizationPercentageValue: Option[GenericString]
    def ebsResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization.ReadOnly
    ]
    def diskResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization.ReadOnly
    ]
    def networkResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization.ReadOnly
    ]
    def maxCpuUtilizationPercentage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "maxCpuUtilizationPercentage",
        maxCpuUtilizationPercentageValue
      )
    def maxMemoryUtilizationPercentage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "maxMemoryUtilizationPercentage",
        maxMemoryUtilizationPercentageValue
      )
    def maxStorageUtilizationPercentage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "maxStorageUtilizationPercentage",
        maxStorageUtilizationPercentageValue
      )
    def ebsResourceUtilization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ebsResourceUtilization",
      ebsResourceUtilizationValue
    )
    def diskResourceUtilization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "diskResourceUtilization",
      diskResourceUtilizationValue
    )
    def networkResourceUtilization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkResourceUtilization",
      networkResourceUtilizationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization
  ) extends io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization.ReadOnly {
    override def maxCpuUtilizationPercentageValue: Option[GenericString] = scala
      .Option(impl.maxCpuUtilizationPercentage())
      .map(value => value: GenericString)
    override def maxMemoryUtilizationPercentageValue: Option[GenericString] =
      scala
        .Option(impl.maxMemoryUtilizationPercentage())
        .map(value => value: GenericString)
    override def maxStorageUtilizationPercentageValue: Option[GenericString] =
      scala
        .Option(impl.maxStorageUtilizationPercentage())
        .map(value => value: GenericString)
    override def ebsResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization.ReadOnly
    ] = scala
      .Option(impl.ebsResourceUtilization())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization
          .wrap(value)
      )
    override def diskResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization.ReadOnly
    ] = scala
      .Option(impl.diskResourceUtilization())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization
          .wrap(value)
      )
    override def networkResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization.ReadOnly
    ] = scala
      .Option(impl.networkResourceUtilization())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization
  ): io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization.ReadOnly =
    new Wrapper(impl)
}
