package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.Value
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DimensionValues(
    key: Option[io.github.vigoo.zioaws.costexplorer.model.Dimension] = None,
    values: Option[Iterable[Value]] = None,
    matchOptions: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.MatchOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DimensionValues = {
    import DimensionValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DimensionValues
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        matchOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.matchOptionsWithStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DimensionValues.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DimensionValues
      .wrap(buildAwsValue())
}
object DimensionValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DimensionValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.DimensionValues =
      io.github.vigoo.zioaws.costexplorer.model.DimensionValues(
        keyValue.map(value => value),
        valuesValue.map(value => value),
        matchOptionsValue.map(value => value)
      )
    def keyValue: Option[io.github.vigoo.zioaws.costexplorer.model.Dimension]
    def valuesValue: Option[List[Value]]
    def matchOptionsValue
        : Option[List[io.github.vigoo.zioaws.costexplorer.model.MatchOption]]
    def key: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Dimension
    ] = AwsError.unwrapOptionField("key", keyValue)
    def values: ZIO[Any, AwsError, List[Value]] =
      AwsError.unwrapOptionField("values", valuesValue)
    def matchOptions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.MatchOption
    ]] = AwsError.unwrapOptionField("matchOptions", matchOptionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DimensionValues
  ) extends io.github.vigoo.zioaws.costexplorer.model.DimensionValues.ReadOnly {
    override def keyValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Dimension] = scala
      .Option(impl.key())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Dimension.wrap(value)
      )
    override def valuesValue: Option[List[Value]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: Value
        }.toList
      )
    override def matchOptionsValue
        : Option[List[io.github.vigoo.zioaws.costexplorer.model.MatchOption]] =
      scala
        .Option(impl.matchOptions())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.costexplorer.model.MatchOption.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DimensionValues
  ): io.github.vigoo.zioaws.costexplorer.model.DimensionValues.ReadOnly =
    new Wrapper(impl)
}
