package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansPurchaseRecommendationSummary(
    estimatedROI: Option[GenericString] = None,
    currencyCode: Option[GenericString] = None,
    estimatedTotalCost: Option[GenericString] = None,
    currentOnDemandSpend: Option[GenericString] = None,
    estimatedSavingsAmount: Option[GenericString] = None,
    totalRecommendationCount: Option[GenericString] = None,
    dailyCommitmentToPurchase: Option[GenericString] = None,
    hourlyCommitmentToPurchase: Option[GenericString] = None,
    estimatedSavingsPercentage: Option[GenericString] = None,
    estimatedMonthlySavingsAmount: Option[GenericString] = None,
    estimatedOnDemandCostWithCurrentCommitment: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary = {
    import SavingsPlansPurchaseRecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary
      .builder()
      .optionallyWith(estimatedROI.map(value => value: java.lang.String))(
        _.estimatedROI
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(estimatedTotalCost.map(value => value: java.lang.String))(
        _.estimatedTotalCost
      )
      .optionallyWith(
        currentOnDemandSpend.map(value => value: java.lang.String)
      )(_.currentOnDemandSpend)
      .optionallyWith(
        estimatedSavingsAmount.map(value => value: java.lang.String)
      )(_.estimatedSavingsAmount)
      .optionallyWith(
        totalRecommendationCount.map(value => value: java.lang.String)
      )(_.totalRecommendationCount)
      .optionallyWith(
        dailyCommitmentToPurchase.map(value => value: java.lang.String)
      )(_.dailyCommitmentToPurchase)
      .optionallyWith(
        hourlyCommitmentToPurchase.map(value => value: java.lang.String)
      )(_.hourlyCommitmentToPurchase)
      .optionallyWith(
        estimatedSavingsPercentage.map(value => value: java.lang.String)
      )(_.estimatedSavingsPercentage)
      .optionallyWith(
        estimatedMonthlySavingsAmount.map(value => value: java.lang.String)
      )(_.estimatedMonthlySavingsAmount)
      .optionallyWith(
        estimatedOnDemandCostWithCurrentCommitment.map(value =>
          value: java.lang.String
        )
      )(_.estimatedOnDemandCostWithCurrentCommitment)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary
      .wrap(buildAwsValue())
}
object SavingsPlansPurchaseRecommendationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary =
      io.github.vigoo.zioaws.costexplorer.model
        .SavingsPlansPurchaseRecommendationSummary(
          estimatedROIValue.map(value => value),
          currencyCodeValue.map(value => value),
          estimatedTotalCostValue.map(value => value),
          currentOnDemandSpendValue.map(value => value),
          estimatedSavingsAmountValue.map(value => value),
          totalRecommendationCountValue.map(value => value),
          dailyCommitmentToPurchaseValue.map(value => value),
          hourlyCommitmentToPurchaseValue.map(value => value),
          estimatedSavingsPercentageValue.map(value => value),
          estimatedMonthlySavingsAmountValue.map(value => value),
          estimatedOnDemandCostWithCurrentCommitmentValue.map(value => value)
        )
    def estimatedROIValue: Option[GenericString]
    def currencyCodeValue: Option[GenericString]
    def estimatedTotalCostValue: Option[GenericString]
    def currentOnDemandSpendValue: Option[GenericString]
    def estimatedSavingsAmountValue: Option[GenericString]
    def totalRecommendationCountValue: Option[GenericString]
    def dailyCommitmentToPurchaseValue: Option[GenericString]
    def hourlyCommitmentToPurchaseValue: Option[GenericString]
    def estimatedSavingsPercentageValue: Option[GenericString]
    def estimatedMonthlySavingsAmountValue: Option[GenericString]
    def estimatedOnDemandCostWithCurrentCommitmentValue: Option[GenericString]
    def estimatedROI: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("estimatedROI", estimatedROIValue)
    def currencyCode: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
    def estimatedTotalCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("estimatedTotalCost", estimatedTotalCostValue)
    def currentOnDemandSpend: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("currentOnDemandSpend", currentOnDemandSpendValue)
    def estimatedSavingsAmount: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("estimatedSavingsAmount", estimatedSavingsAmountValue)
    def totalRecommendationCount: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "totalRecommendationCount",
        totalRecommendationCountValue
      )
    def dailyCommitmentToPurchase: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "dailyCommitmentToPurchase",
        dailyCommitmentToPurchaseValue
      )
    def hourlyCommitmentToPurchase: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "hourlyCommitmentToPurchase",
        hourlyCommitmentToPurchaseValue
      )
    def estimatedSavingsPercentage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedSavingsPercentage",
        estimatedSavingsPercentageValue
      )
    def estimatedMonthlySavingsAmount: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedMonthlySavingsAmount",
        estimatedMonthlySavingsAmountValue
      )
    def estimatedOnDemandCostWithCurrentCommitment
        : ZIO[Any, AwsError, GenericString] = AwsError.unwrapOptionField(
      "estimatedOnDemandCostWithCurrentCommitment",
      estimatedOnDemandCostWithCurrentCommitmentValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.ReadOnly {
    override def estimatedROIValue: Option[GenericString] =
      scala.Option(impl.estimatedROI()).map(value => value: GenericString)
    override def currencyCodeValue: Option[GenericString] =
      scala.Option(impl.currencyCode()).map(value => value: GenericString)
    override def estimatedTotalCostValue: Option[GenericString] =
      scala.Option(impl.estimatedTotalCost()).map(value => value: GenericString)
    override def currentOnDemandSpendValue: Option[GenericString] = scala
      .Option(impl.currentOnDemandSpend())
      .map(value => value: GenericString)
    override def estimatedSavingsAmountValue: Option[GenericString] = scala
      .Option(impl.estimatedSavingsAmount())
      .map(value => value: GenericString)
    override def totalRecommendationCountValue: Option[GenericString] = scala
      .Option(impl.totalRecommendationCount())
      .map(value => value: GenericString)
    override def dailyCommitmentToPurchaseValue: Option[GenericString] = scala
      .Option(impl.dailyCommitmentToPurchase())
      .map(value => value: GenericString)
    override def hourlyCommitmentToPurchaseValue: Option[GenericString] = scala
      .Option(impl.hourlyCommitmentToPurchase())
      .map(value => value: GenericString)
    override def estimatedSavingsPercentageValue: Option[GenericString] = scala
      .Option(impl.estimatedSavingsPercentage())
      .map(value => value: GenericString)
    override def estimatedMonthlySavingsAmountValue: Option[GenericString] =
      scala
        .Option(impl.estimatedMonthlySavingsAmount())
        .map(value => value: GenericString)
    override def estimatedOnDemandCostWithCurrentCommitmentValue
        : Option[GenericString] = scala
      .Option(impl.estimatedOnDemandCostWithCurrentCommitment())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.ReadOnly =
    new Wrapper(impl)
}
