package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProvideAnomalyFeedbackResponse(anomalyId: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse = {
    import ProvideAnomalyFeedbackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse
      .builder()
      .anomalyId(anomalyId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse
      .wrap(buildAwsValue())
}
object ProvideAnomalyFeedbackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .ProvideAnomalyFeedbackResponse(anomalyIdValue)
    def anomalyIdValue: GenericString
    def anomalyId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(anomalyIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.ReadOnly {
    override def anomalyIdValue: GenericString = impl.anomalyId(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse
  ): io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.ReadOnly =
    new Wrapper(impl)
}
