package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait MonitorType {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.MonitorType
}
object MonitorType {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.MonitorType
  ): io.github.vigoo.zioaws.costexplorer.model.MonitorType = value match {
    case software.amazon.awssdk.services.costexplorer.model.MonitorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.MonitorType.DIMENSIONAL =>
      val r = DIMENSIONAL
      r
    case software.amazon.awssdk.services.costexplorer.model.MonitorType.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.MonitorType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.MonitorType =
      software.amazon.awssdk.services.costexplorer.model.MonitorType.UNKNOWN_TO_SDK_VERSION
  }
  case object DIMENSIONAL
      extends io.github.vigoo.zioaws.costexplorer.model.MonitorType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.MonitorType =
      software.amazon.awssdk.services.costexplorer.model.MonitorType.DIMENSIONAL
  }
  case object CUSTOM
      extends io.github.vigoo.zioaws.costexplorer.model.MonitorType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.MonitorType =
      software.amazon.awssdk.services.costexplorer.model.MonitorType.CUSTOM
  }
}
