package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NextPageToken,
  NonNegativeInteger,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRightsizingRecommendationRequest(
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    configuration: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration
    ] = None,
    service: GenericString,
    pageSize: Option[NonNegativeInteger] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest = {
    import GetRightsizingRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .service(service: java.lang.String)
      .optionallyWith(pageSize.map(value => value: Integer))(_.pageSize)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest
      .wrap(buildAwsValue())
}
object GetRightsizingRecommendationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .GetRightsizingRecommendationRequest(
          filterValue.map(value => value.editable),
          configurationValue.map(value => value.editable),
          serviceValue,
          pageSizeValue.map(value => value),
          nextPageTokenValue.map(value => value)
        )
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def configurationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly
    ]
    def serviceValue: GenericString
    def pageSizeValue: Option[NonNegativeInteger]
    def nextPageTokenValue: Option[NextPageToken]
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def configuration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configurationValue)
    def service: ZIO[Any, Nothing, GenericString] = ZIO.succeed(serviceValue)
    def pageSize: ZIO[Any, AwsError, NonNegativeInteger] =
      AwsError.unwrapOptionField("pageSize", pageSizeValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest.ReadOnly {
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def configurationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration
          .wrap(value)
      )
    override def serviceValue: GenericString = impl.service(): GenericString
    override def pageSizeValue: Option[NonNegativeInteger] =
      scala.Option(impl.pageSize()).map(value => value: NonNegativeInteger)
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest.ReadOnly =
    new Wrapper(impl)
}
