package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.YearMonthDay
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DateInterval(start: YearMonthDay, end: YearMonthDay) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DateInterval = {
    import DateInterval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DateInterval
      .builder()
      .start(start: java.lang.String)
      .end(end: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DateInterval.wrap(buildAwsValue())
}
object DateInterval {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DateInterval
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.DateInterval =
      io.github.vigoo.zioaws.costexplorer.model
        .DateInterval(startValue, endValue)
    def startValue: YearMonthDay
    def endValue: YearMonthDay
    def start: ZIO[Any, Nothing, YearMonthDay] = ZIO.succeed(startValue)
    def end: ZIO[Any, Nothing, YearMonthDay] = ZIO.succeed(endValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DateInterval
  ) extends io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly {
    override def startValue: YearMonthDay = impl.start(): YearMonthDay
    override def endValue: YearMonthDay = impl.end(): YearMonthDay
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DateInterval
  ): io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
    new Wrapper(impl)
}
