package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  CoverageNormalizedUnitsPercentage,
  TotalRunningNormalizedUnits,
  ReservedNormalizedUnits,
  OnDemandNormalizedUnits
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CoverageNormalizedUnits(
    onDemandNormalizedUnits: Option[OnDemandNormalizedUnits] = None,
    reservedNormalizedUnits: Option[ReservedNormalizedUnits] = None,
    totalRunningNormalizedUnits: Option[TotalRunningNormalizedUnits] = None,
    coverageNormalizedUnitsPercentage: Option[
      CoverageNormalizedUnitsPercentage
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CoverageNormalizedUnits = {
    import CoverageNormalizedUnits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CoverageNormalizedUnits
      .builder()
      .optionallyWith(
        onDemandNormalizedUnits.map(value => value: java.lang.String)
      )(_.onDemandNormalizedUnits)
      .optionallyWith(
        reservedNormalizedUnits.map(value => value: java.lang.String)
      )(_.reservedNormalizedUnits)
      .optionallyWith(
        totalRunningNormalizedUnits.map(value => value: java.lang.String)
      )(_.totalRunningNormalizedUnits)
      .optionallyWith(
        coverageNormalizedUnitsPercentage.map(value => value: java.lang.String)
      )(_.coverageNormalizedUnitsPercentage)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits
      .wrap(buildAwsValue())
}
object CoverageNormalizedUnits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CoverageNormalizedUnits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits =
      io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits(
        onDemandNormalizedUnitsValue.map(value => value),
        reservedNormalizedUnitsValue.map(value => value),
        totalRunningNormalizedUnitsValue.map(value => value),
        coverageNormalizedUnitsPercentageValue.map(value => value)
      )
    def onDemandNormalizedUnitsValue: Option[OnDemandNormalizedUnits]
    def reservedNormalizedUnitsValue: Option[ReservedNormalizedUnits]
    def totalRunningNormalizedUnitsValue: Option[TotalRunningNormalizedUnits]
    def coverageNormalizedUnitsPercentageValue
        : Option[CoverageNormalizedUnitsPercentage]
    def onDemandNormalizedUnits: ZIO[Any, AwsError, OnDemandNormalizedUnits] =
      AwsError.unwrapOptionField(
        "onDemandNormalizedUnits",
        onDemandNormalizedUnitsValue
      )
    def reservedNormalizedUnits: ZIO[Any, AwsError, ReservedNormalizedUnits] =
      AwsError.unwrapOptionField(
        "reservedNormalizedUnits",
        reservedNormalizedUnitsValue
      )
    def totalRunningNormalizedUnits
        : ZIO[Any, AwsError, TotalRunningNormalizedUnits] =
      AwsError.unwrapOptionField(
        "totalRunningNormalizedUnits",
        totalRunningNormalizedUnitsValue
      )
    def coverageNormalizedUnitsPercentage
        : ZIO[Any, AwsError, CoverageNormalizedUnitsPercentage] =
      AwsError.unwrapOptionField(
        "coverageNormalizedUnitsPercentage",
        coverageNormalizedUnitsPercentageValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CoverageNormalizedUnits
  ) extends io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits.ReadOnly {
    override def onDemandNormalizedUnitsValue: Option[OnDemandNormalizedUnits] =
      scala
        .Option(impl.onDemandNormalizedUnits())
        .map(value => value: OnDemandNormalizedUnits)
    override def reservedNormalizedUnitsValue: Option[ReservedNormalizedUnits] =
      scala
        .Option(impl.reservedNormalizedUnits())
        .map(value => value: ReservedNormalizedUnits)
    override def totalRunningNormalizedUnitsValue
        : Option[TotalRunningNormalizedUnits] = scala
      .Option(impl.totalRunningNormalizedUnits())
      .map(value => value: TotalRunningNormalizedUnits)
    override def coverageNormalizedUnitsPercentageValue
        : Option[CoverageNormalizedUnitsPercentage] = scala
      .Option(impl.coverageNormalizedUnitsPercentage())
      .map(value => value: CoverageNormalizedUnitsPercentage)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CoverageNormalizedUnits
  ): io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits.ReadOnly =
    new Wrapper(impl)
}
