package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  CostCategoryValue,
  CostCategoryName,
  Arn,
  ZonedDateTime,
  NonNegativeInteger
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CostCategoryReference(
    costCategoryArn: Option[Arn] = None,
    name: Option[CostCategoryName] = None,
    effectiveStart: Option[ZonedDateTime] = None,
    effectiveEnd: Option[ZonedDateTime] = None,
    numberOfRules: Option[NonNegativeInteger] = None,
    processingStatus: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus
    ]] = None,
    values: Option[Iterable[CostCategoryValue]] = None,
    defaultValue: Option[CostCategoryValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CostCategoryReference = {
    import CostCategoryReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryReference
      .builder()
      .optionallyWith(costCategoryArn.map(value => value: java.lang.String))(
        _.costCategoryArn
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(effectiveStart.map(value => value: java.lang.String))(
        _.effectiveStart
      )
      .optionallyWith(effectiveEnd.map(value => value: java.lang.String))(
        _.effectiveEnd
      )
      .optionallyWith(numberOfRules.map(value => value: Integer))(
        _.numberOfRules
      )
      .optionallyWith(
        processingStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processingStatus)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference
      .wrap(buildAwsValue())
}
object CostCategoryReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CostCategoryReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference =
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference(
        costCategoryArnValue.map(value => value),
        nameValue.map(value => value),
        effectiveStartValue.map(value => value),
        effectiveEndValue.map(value => value),
        numberOfRulesValue.map(value => value),
        processingStatusValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        valuesValue.map(value => value),
        defaultValueValue.map(value => value)
      )
    def costCategoryArnValue: Option[Arn]
    def nameValue: Option[CostCategoryName]
    def effectiveStartValue: Option[ZonedDateTime]
    def effectiveEndValue: Option[ZonedDateTime]
    def numberOfRulesValue: Option[NonNegativeInteger]
    def processingStatusValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly
    ]]
    def valuesValue: Option[List[CostCategoryValue]]
    def defaultValueValue: Option[CostCategoryValue]
    def costCategoryArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("costCategoryArn", costCategoryArnValue)
    def name: ZIO[Any, AwsError, CostCategoryName] =
      AwsError.unwrapOptionField("name", nameValue)
    def effectiveStart: ZIO[Any, AwsError, ZonedDateTime] =
      AwsError.unwrapOptionField("effectiveStart", effectiveStartValue)
    def effectiveEnd: ZIO[Any, AwsError, ZonedDateTime] =
      AwsError.unwrapOptionField("effectiveEnd", effectiveEndValue)
    def numberOfRules: ZIO[Any, AwsError, NonNegativeInteger] =
      AwsError.unwrapOptionField("numberOfRules", numberOfRulesValue)
    def processingStatus: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("processingStatus", processingStatusValue)
    def values: ZIO[Any, AwsError, List[CostCategoryValue]] =
      AwsError.unwrapOptionField("values", valuesValue)
    def defaultValue: ZIO[Any, AwsError, CostCategoryValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryReference
  ) extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference.ReadOnly {
    override def costCategoryArnValue: Option[Arn] =
      scala.Option(impl.costCategoryArn()).map(value => value: Arn)
    override def nameValue: Option[CostCategoryName] =
      scala.Option(impl.name()).map(value => value: CostCategoryName)
    override def effectiveStartValue: Option[ZonedDateTime] =
      scala.Option(impl.effectiveStart()).map(value => value: ZonedDateTime)
    override def effectiveEndValue: Option[ZonedDateTime] =
      scala.Option(impl.effectiveEnd()).map(value => value: ZonedDateTime)
    override def numberOfRulesValue: Option[NonNegativeInteger] =
      scala.Option(impl.numberOfRules()).map(value => value: NonNegativeInteger)
    override def processingStatusValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly
    ]] = scala
      .Option(impl.processingStatus())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus
            .wrap(item)
        }.toList
      )
    override def valuesValue: Option[List[CostCategoryValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: CostCategoryValue
        }.toList
      )
    override def defaultValueValue: Option[CostCategoryValue] =
      scala.Option(impl.defaultValue()).map(value => value: CostCategoryValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryReference
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference.ReadOnly =
    new Wrapper(impl)
}
