package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference.ReadOnly
import io.github.vigoo.zioaws.costexplorer.CostExplorer
import io.github.vigoo.zioaws.core.{
  AwsServiceBase,
  StreamingOutputResult,
  AwsError
}
import software.amazon.awssdk.services.costexplorer.model.{
  DeleteAnomalyMonitorRequest,
  GetSavingsPlansUtilizationDetailsResponse,
  GetUsageForecastRequest,
  GetReservationUtilizationRequest,
  GetAnomalySubscriptionsResponse,
  CostCategoryReference,
  ProvideAnomalyFeedbackRequest,
  DescribeCostCategoryDefinitionRequest,
  GetTagsResponse,
  UpdateAnomalyMonitorRequest,
  DeleteCostCategoryDefinitionResponse,
  GetAnomalySubscriptionsRequest,
  UpdateAnomalySubscriptionRequest,
  DeleteAnomalyMonitorResponse,
  GetCostAndUsageResponse,
  GetDimensionValuesRequest,
  SavingsPlansUtilizationDetail,
  UpdateCostCategoryDefinitionRequest,
  UpdateAnomalyMonitorResponse,
  CreateAnomalySubscriptionRequest,
  CreateCostCategoryDefinitionResponse,
  GetReservationPurchaseRecommendationRequest,
  UpdateAnomalySubscriptionResponse,
  GetCostAndUsageWithResourcesResponse,
  GetCostAndUsageRequest,
  GetRightsizingRecommendationResponse,
  GetReservationCoverageRequest,
  ListCostCategoryDefinitionsResponse,
  GetAnomaliesResponse,
  CreateAnomalySubscriptionResponse,
  GetDimensionValuesResponse,
  GetSavingsPlansUtilizationRequest,
  ProvideAnomalyFeedbackResponse,
  DeleteAnomalySubscriptionRequest,
  GetAnomalyMonitorsRequest,
  GetSavingsPlansUtilizationResponse,
  DescribeCostCategoryDefinitionResponse,
  DeleteCostCategoryDefinitionRequest,
  SavingsPlansCoverage,
  GetSavingsPlansUtilizationDetailsRequest,
  CreateAnomalyMonitorRequest,
  GetCostCategoriesRequest,
  GetReservationCoverageResponse,
  CreateCostCategoryDefinitionRequest,
  GetAnomalyMonitorsResponse,
  GetCostCategoriesResponse,
  GetRightsizingRecommendationRequest,
  GetReservationPurchaseRecommendationResponse,
  UpdateCostCategoryDefinitionResponse,
  GetTagsRequest,
  GetSavingsPlansCoverageResponse,
  GetCostAndUsageWithResourcesRequest,
  GetReservationUtilizationResponse,
  GetCostForecastRequest,
  GetSavingsPlansPurchaseRecommendationResponse,
  DeleteAnomalySubscriptionResponse,
  ListCostCategoryDefinitionsRequest,
  CreateAnomalyMonitorResponse,
  GetAnomaliesRequest,
  GetUsageForecastResponse,
  GetSavingsPlansCoverageRequest,
  GetCostForecastResponse,
  GetSavingsPlansPurchaseRecommendationRequest
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
import software.amazon.awssdk.services.costexplorer.{
  CostExplorerAsyncClientBuilder,
  CostExplorerAsyncClient
}
package object costexplorer {
  import scala.jdk.CollectionConverters.*
  type CostExplorer = Has[CostExplorer.Service]
  object CostExplorer {
    trait Service extends AspectSupport[Service] {
      val api: CostExplorerAsyncClient
      def updateAnomalySubscription(
          request: io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.ReadOnly
      ]
      def createAnomalySubscription(
          request: io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.ReadOnly
      ]
      def getCostAndUsageWithResources(
          request: io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.ReadOnly
      ]
      def updateAnomalyMonitor(
          request: io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorResponse.ReadOnly
      ]
      def deleteCostCategoryDefinition(
          request: io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.ReadOnly
      ]
      def getSavingsPlansPurchaseRecommendation(
          request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly
      ]
      def getSavingsPlansCoverage(
          request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly
      ]
      def getSavingsPlansUtilization(
          request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.ReadOnly
      ]
      def createCostCategoryDefinition(
          request: io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionResponse.ReadOnly
      ]
      def createAnomalyMonitor(
          request: io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorResponse.ReadOnly
      ]
      def getSavingsPlansUtilizationDetails(
          request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
      ): ZIO[Any, AwsError, StreamingOutputResult[
        Any,
        io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly,
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly
      ]]
      def getCostCategories(
          request: io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.ReadOnly
      ]
      def getReservationPurchaseRecommendation(
          request: io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.ReadOnly
      ]
      def getUsageForecast(
          request: io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.ReadOnly
      ]
      def getDimensionValues(
          request: io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.ReadOnly
      ]
      def getReservationUtilization(
          request: io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.ReadOnly
      ]
      def deleteAnomalyMonitor(
          request: io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorResponse.ReadOnly
      ]
      def getCostAndUsage(
          request: io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageResponse.ReadOnly
      ]
      def deleteAnomalySubscription(
          request: io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionResponse.ReadOnly
      ]
      def getCostForecast(
          request: io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetCostForecastResponse.ReadOnly
      ]
      def listCostCategoryDefinitions(
          request: io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest
      ): ZStream[Any, AwsError, ReadOnly]
      def getAnomalySubscriptions(
          request: io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.ReadOnly
      ]
      def getAnomalies(
          request: io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.ReadOnly
      ]
      def getRightsizingRecommendation(
          request: io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.ReadOnly
      ]
      def provideAnomalyFeedback(
          request: io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.ReadOnly
      ]
      def updateCostCategoryDefinition(
          request: io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.ReadOnly
      ]
      def getReservationCoverage(
          request: io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.ReadOnly
      ]
      def describeCostCategoryDefinition(
          request: io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.ReadOnly
      ]
      def getAnomalyMonitors(
          request: io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.ReadOnly
      ]
      def getTags(
          request: io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.ReadOnly
      ]
    }
    object CostExplorerMock extends Mock[CostExplorer] {
      object UpdateAnomalySubscription
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.ReadOnly
          ]
      object CreateAnomalySubscription
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.ReadOnly
          ]
      object GetCostAndUsageWithResources
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.ReadOnly
          ]
      object UpdateAnomalyMonitor
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorResponse.ReadOnly
          ]
      object DeleteCostCategoryDefinition
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.ReadOnly
          ]
      object GetSavingsPlansPurchaseRecommendation
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly
          ]
      object GetSavingsPlansCoverage
          extends Stream[
            io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly
          ]
      object GetSavingsPlansUtilization
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.ReadOnly
          ]
      object CreateCostCategoryDefinition
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionResponse.ReadOnly
          ]
      object CreateAnomalyMonitor
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorResponse.ReadOnly
          ]
      object GetSavingsPlansUtilizationDetails
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest,
            AwsError,
            StreamingOutputResult[
              Any,
              io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly,
              io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly
            ]
          ]
      object GetCostCategories
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.ReadOnly
          ]
      object GetReservationPurchaseRecommendation
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.ReadOnly
          ]
      object GetUsageForecast
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.ReadOnly
          ]
      object GetDimensionValues
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.ReadOnly
          ]
      object GetReservationUtilization
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.ReadOnly
          ]
      object DeleteAnomalyMonitor
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorResponse.ReadOnly
          ]
      object GetCostAndUsage
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageResponse.ReadOnly
          ]
      object DeleteAnomalySubscription
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionResponse.ReadOnly
          ]
      object GetCostForecast
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetCostForecastResponse.ReadOnly
          ]
      object ListCostCategoryDefinitions
          extends Stream[
            io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest,
            AwsError,
            ReadOnly
          ]
      object GetAnomalySubscriptions
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.ReadOnly
          ]
      object GetAnomalies
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.ReadOnly
          ]
      object GetRightsizingRecommendation
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.ReadOnly
          ]
      object ProvideAnomalyFeedback
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.ReadOnly
          ]
      object UpdateCostCategoryDefinition
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.ReadOnly
          ]
      object GetReservationCoverage
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.ReadOnly
          ]
      object DescribeCostCategoryDefinition
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.ReadOnly
          ]
      object GetAnomalyMonitors
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.ReadOnly
          ]
      object GetTags
          extends Effect[
            io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest,
            AwsError,
            io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], CostExplorer] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new CostExplorer.Service {
              val api: CostExplorerAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): CostExplorer.Service = this
              def updateAnomalySubscription(
                  request: io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.ReadOnly
              ] = proxy(UpdateAnomalySubscription, request)
              def createAnomalySubscription(
                  request: io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.ReadOnly
              ] = proxy(CreateAnomalySubscription, request)
              def getCostAndUsageWithResources(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.ReadOnly
              ] = proxy(GetCostAndUsageWithResources, request)
              def updateAnomalyMonitor(
                  request: io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorResponse.ReadOnly
              ] = proxy(UpdateAnomalyMonitor, request)
              def deleteCostCategoryDefinition(
                  request: io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.ReadOnly
              ] = proxy(DeleteCostCategoryDefinition, request)
              def getSavingsPlansPurchaseRecommendation(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly
              ] = proxy(GetSavingsPlansPurchaseRecommendation, request)
              def getSavingsPlansCoverage(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly
              ] = rts.unsafeRun(proxy(GetSavingsPlansCoverage, request))
              def getSavingsPlansUtilization(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.ReadOnly
              ] = proxy(GetSavingsPlansUtilization, request)
              def createCostCategoryDefinition(
                  request: io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionResponse.ReadOnly
              ] = proxy(CreateCostCategoryDefinition, request)
              def createAnomalyMonitor(
                  request: io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorResponse.ReadOnly
              ] = proxy(CreateAnomalyMonitor, request)
              def getSavingsPlansUtilizationDetails(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
              ): ZIO[Any, AwsError, StreamingOutputResult[
                Any,
                io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly,
                io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly
              ]] = proxy(GetSavingsPlansUtilizationDetails, request)
              def getCostCategories(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.ReadOnly
              ] = proxy(GetCostCategories, request)
              def getReservationPurchaseRecommendation(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.ReadOnly
              ] = proxy(GetReservationPurchaseRecommendation, request)
              def getUsageForecast(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.ReadOnly
              ] = proxy(GetUsageForecast, request)
              def getDimensionValues(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.ReadOnly
              ] = proxy(GetDimensionValues, request)
              def getReservationUtilization(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.ReadOnly
              ] = proxy(GetReservationUtilization, request)
              def deleteAnomalyMonitor(
                  request: io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorResponse.ReadOnly
              ] = proxy(DeleteAnomalyMonitor, request)
              def getCostAndUsage(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageResponse.ReadOnly
              ] = proxy(GetCostAndUsage, request)
              def deleteAnomalySubscription(
                  request: io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionResponse.ReadOnly
              ] = proxy(DeleteAnomalySubscription, request)
              def getCostForecast(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetCostForecastResponse.ReadOnly
              ] = proxy(GetCostForecast, request)
              def listCostCategoryDefinitions(
                  request: io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest
              ): ZStream[Any, AwsError, ReadOnly] =
                rts.unsafeRun(proxy(ListCostCategoryDefinitions, request))
              def getAnomalySubscriptions(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.ReadOnly
              ] = proxy(GetAnomalySubscriptions, request)
              def getAnomalies(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.ReadOnly
              ] = proxy(GetAnomalies, request)
              def getRightsizingRecommendation(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.ReadOnly
              ] = proxy(GetRightsizingRecommendation, request)
              def provideAnomalyFeedback(
                  request: io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.ReadOnly
              ] = proxy(ProvideAnomalyFeedback, request)
              def updateCostCategoryDefinition(
                  request: io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.ReadOnly
              ] = proxy(UpdateCostCategoryDefinition, request)
              def getReservationCoverage(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.ReadOnly
              ] = proxy(GetReservationCoverage, request)
              def describeCostCategoryDefinition(
                  request: io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.ReadOnly
              ] = proxy(DescribeCostCategoryDefinition, request)
              def getAnomalyMonitors(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.ReadOnly
              ] = proxy(GetAnomalyMonitors, request)
              def getTags(
                  request: io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.ReadOnly
              ] = proxy(GetTags, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, CostExplorer] = customized(
    identity
  )
  def customized(
      customization: CostExplorerAsyncClientBuilder => CostExplorerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CostExplorer] = managed(
    customization
  ).toLayer
  def managed(
      customization: CostExplorerAsyncClientBuilder => CostExplorerAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CostExplorer.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = CostExplorerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CostExplorerAsyncClient, CostExplorerAsyncClientBuilder](
        builder
      )
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[
        CostExplorerAsyncClient,
        CostExplorerAsyncClientBuilder
      ](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  )
    yield new CostExplorerImpl(
      client,
      AwsCallAspect.identity,
      ().asInstanceOf[Any]
    )
  private class CostExplorerImpl[R](
      override val api: CostExplorerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends CostExplorer.Service
      with AwsServiceBase[R, CostExplorerImpl] {
    override val serviceName: String = "CostExplorer"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): CostExplorerImpl[R1] = new CostExplorerImpl(api, newAspect, r)
    def updateAnomalySubscription(
        request: io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateAnomalySubscriptionRequest,
      UpdateAnomalySubscriptionResponse
    ]("updateAnomalySubscription", api.updateAnomalySubscription)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.wrap
    ).provide(r)
    def createAnomalySubscription(
        request: io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAnomalySubscriptionRequest,
      CreateAnomalySubscriptionResponse
    ]("createAnomalySubscription", api.createAnomalySubscription)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.wrap
    ).provide(r)
    def getCostAndUsageWithResources(
        request: io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCostAndUsageWithResourcesRequest,
      GetCostAndUsageWithResourcesResponse
    ]("getCostAndUsageWithResources", api.getCostAndUsageWithResources)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.wrap
    ).provide(r)
    def updateAnomalyMonitor(
        request: io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateAnomalyMonitorRequest,
      UpdateAnomalyMonitorResponse
    ]("updateAnomalyMonitor", api.updateAnomalyMonitor)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorResponse.wrap
      )
      .provide(r)
    def deleteCostCategoryDefinition(
        request: io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCostCategoryDefinitionRequest,
      DeleteCostCategoryDefinitionResponse
    ]("deleteCostCategoryDefinition", api.deleteCostCategoryDefinition)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.wrap
    ).provide(r)
    def getSavingsPlansPurchaseRecommendation(
        request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSavingsPlansPurchaseRecommendationRequest,
      GetSavingsPlansPurchaseRecommendationResponse
    ](
      "getSavingsPlansPurchaseRecommendation",
      api.getSavingsPlansPurchaseRecommendation
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.wrap
      )
      .provide(r)
    def getSavingsPlansCoverage(
        request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetSavingsPlansCoverageRequest,
      GetSavingsPlansCoverageResponse,
      SavingsPlansCoverage
    ](
      "getSavingsPlansCoverage",
      api.getSavingsPlansCoverage,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.savingsPlansCoverages().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage
          .wrap(item)
      )
      .provide(r)
    def getSavingsPlansUtilization(
        request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSavingsPlansUtilizationRequest,
      GetSavingsPlansUtilizationResponse
    ]("getSavingsPlansUtilization", api.getSavingsPlansUtilization)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.wrap
    ).provide(r)
    def createCostCategoryDefinition(
        request: io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCostCategoryDefinitionRequest,
      CreateCostCategoryDefinitionResponse
    ]("createCostCategoryDefinition", api.createCostCategoryDefinition)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionResponse.wrap
    ).provide(r)
    def createAnomalyMonitor(
        request: io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAnomalyMonitorRequest,
      CreateAnomalyMonitorResponse
    ]("createAnomalyMonitor", api.createAnomalyMonitor)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorResponse.wrap
      )
      .provide(r)
    def getSavingsPlansUtilizationDetails(
        request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly
    ]] = asyncPaginatedRequest[
      GetSavingsPlansUtilizationDetailsRequest,
      GetSavingsPlansUtilizationDetailsResponse,
      SavingsPlansUtilizationDetail
    ](
      "getSavingsPlansUtilizationDetails",
      api.getSavingsPlansUtilizationDetails,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.savingsPlansUtilizationDetails().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail
                .wrap(item)
            )
          )
          .provide(r)
      )
      .provide(r)
    def getCostCategories(
        request: io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCostCategoriesRequest,
      GetCostCategoriesResponse
    ]("getCostCategories", api.getCostCategories)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.wrap
      )
      .provide(r)
    def getReservationPurchaseRecommendation(
        request: io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetReservationPurchaseRecommendationRequest,
      GetReservationPurchaseRecommendationResponse
    ](
      "getReservationPurchaseRecommendation",
      api.getReservationPurchaseRecommendation
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.wrap
      )
      .provide(r)
    def getUsageForecast(
        request: io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.ReadOnly
    ] = asyncRequestResponse[GetUsageForecastRequest, GetUsageForecastResponse](
      "getUsageForecast",
      api.getUsageForecast
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.wrap
      )
      .provide(r)
    def getDimensionValues(
        request: io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDimensionValuesRequest,
      GetDimensionValuesResponse
    ]("getDimensionValues", api.getDimensionValues)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.wrap
      )
      .provide(r)
    def getReservationUtilization(
        request: io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetReservationUtilizationRequest,
      GetReservationUtilizationResponse
    ]("getReservationUtilization", api.getReservationUtilization)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.wrap
    ).provide(r)
    def deleteAnomalyMonitor(
        request: io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAnomalyMonitorRequest,
      DeleteAnomalyMonitorResponse
    ]("deleteAnomalyMonitor", api.deleteAnomalyMonitor)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorResponse.wrap
      )
      .provide(r)
    def getCostAndUsage(
        request: io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageResponse.ReadOnly
    ] = asyncRequestResponse[GetCostAndUsageRequest, GetCostAndUsageResponse](
      "getCostAndUsage",
      api.getCostAndUsage
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageResponse.wrap
      )
      .provide(r)
    def deleteAnomalySubscription(
        request: io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAnomalySubscriptionRequest,
      DeleteAnomalySubscriptionResponse
    ]("deleteAnomalySubscription", api.deleteAnomalySubscription)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionResponse.wrap
    ).provide(r)
    def getCostForecast(
        request: io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetCostForecastResponse.ReadOnly
    ] = asyncRequestResponse[GetCostForecastRequest, GetCostForecastResponse](
      "getCostForecast",
      api.getCostForecast
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.GetCostForecastResponse.wrap
      )
      .provide(r)
    def listCostCategoryDefinitions(
        request: io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListCostCategoryDefinitionsRequest,
      ListCostCategoryDefinitionsResponse,
      CostCategoryReference
    ](
      "listCostCategoryDefinitions",
      api.listCostCategoryDefinitions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.costCategoryReferences().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference
          .wrap(item)
      )
      .provide(r)
    def getAnomalySubscriptions(
        request: io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAnomalySubscriptionsRequest,
      GetAnomalySubscriptionsResponse
    ]("getAnomalySubscriptions", api.getAnomalySubscriptions)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.wrap
    ).provide(r)
    def getAnomalies(
        request: io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.ReadOnly
    ] = asyncRequestResponse[GetAnomaliesRequest, GetAnomaliesResponse](
      "getAnomalies",
      api.getAnomalies
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.wrap)
      .provide(r)
    def getRightsizingRecommendation(
        request: io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRightsizingRecommendationRequest,
      GetRightsizingRecommendationResponse
    ]("getRightsizingRecommendation", api.getRightsizingRecommendation)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.wrap
    ).provide(r)
    def provideAnomalyFeedback(
        request: io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      ProvideAnomalyFeedbackRequest,
      ProvideAnomalyFeedbackResponse
    ]("provideAnomalyFeedback", api.provideAnomalyFeedback)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.wrap
    ).provide(r)
    def updateCostCategoryDefinition(
        request: io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateCostCategoryDefinitionRequest,
      UpdateCostCategoryDefinitionResponse
    ]("updateCostCategoryDefinition", api.updateCostCategoryDefinition)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.wrap
    ).provide(r)
    def getReservationCoverage(
        request: io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.ReadOnly
    ] = asyncRequestResponse[
      GetReservationCoverageRequest,
      GetReservationCoverageResponse
    ]("getReservationCoverage", api.getReservationCoverage)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.wrap
    ).provide(r)
    def describeCostCategoryDefinition(
        request: io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCostCategoryDefinitionRequest,
      DescribeCostCategoryDefinitionResponse
    ]("describeCostCategoryDefinition", api.describeCostCategoryDefinition)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.wrap
    ).provide(r)
    def getAnomalyMonitors(
        request: io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAnomalyMonitorsRequest,
      GetAnomalyMonitorsResponse
    ]("getAnomalyMonitors", api.getAnomalyMonitors)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.wrap
      )
      .provide(r)
    def getTags(
        request: io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.ReadOnly
    ] = asyncRequestResponse[GetTagsRequest, GetTagsResponse](
      "getTags",
      api.getTags
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.wrap)
      .provide(r)
  }
  def updateAnomalySubscription(
      request: io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateAnomalySubscription(request))
  def createAnomalySubscription(
      request: io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.ReadOnly
  ] = ZIO.accessM(_.get.createAnomalySubscription(request))
  def getCostAndUsageWithResources(
      request: io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getCostAndUsageWithResources(request))
  def updateAnomalyMonitor(
      request: io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateAnomalyMonitor(request))
  def deleteCostCategoryDefinition(
      request: io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteCostCategoryDefinition(request))
  def getSavingsPlansPurchaseRecommendation(
      request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getSavingsPlansPurchaseRecommendation(request))
  def getSavingsPlansCoverage(
      request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageRequest
  ): ZStream[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly
  ] = ZStream.accessStream(_.get.getSavingsPlansCoverage(request))
  def getSavingsPlansUtilization(
      request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getSavingsPlansUtilization(request))
  def createCostCategoryDefinition(
      request: io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionResponse.ReadOnly
  ] = ZIO.accessM(_.get.createCostCategoryDefinition(request))
  def createAnomalyMonitor(
      request: io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.CreateAnomalyMonitorResponse.ReadOnly
  ] = ZIO.accessM(_.get.createAnomalyMonitor(request))
  def getSavingsPlansUtilizationDetails(
      request: io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
  ): ZIO[CostExplorer, AwsError, StreamingOutputResult[
    Any,
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly,
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly
  ]] = ZIO.accessM(_.get.getSavingsPlansUtilizationDetails(request))
  def getCostCategories(
      request: io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getCostCategories(request))
  def getReservationPurchaseRecommendation(
      request: io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getReservationPurchaseRecommendation(request))
  def getUsageForecast(
      request: io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.ReadOnly
  ] = ZIO.accessM(_.get.getUsageForecast(request))
  def getDimensionValues(
      request: io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDimensionValues(request))
  def getReservationUtilization(
      request: io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getReservationUtilization(request))
  def deleteAnomalyMonitor(
      request: io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteAnomalyMonitor(request))
  def getCostAndUsage(
      request: io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageResponse.ReadOnly
  ] = ZIO.accessM(_.get.getCostAndUsage(request))
  def deleteAnomalySubscription(
      request: io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteAnomalySubscription(request))
  def getCostForecast(
      request: io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetCostForecastResponse.ReadOnly
  ] = ZIO.accessM(_.get.getCostForecast(request))
  def listCostCategoryDefinitions(
      request: io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest
  ): ZStream[CostExplorer, AwsError, ReadOnly] =
    ZStream.accessStream(_.get.listCostCategoryDefinitions(request))
  def getAnomalySubscriptions(
      request: io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getAnomalySubscriptions(request))
  def getAnomalies(
      request: io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getAnomalies(request))
  def getRightsizingRecommendation(
      request: io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRightsizingRecommendation(request))
  def provideAnomalyFeedback(
      request: io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackResponse.ReadOnly
  ] = ZIO.accessM(_.get.provideAnomalyFeedback(request))
  def updateCostCategoryDefinition(
      request: io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateCostCategoryDefinition(request))
  def getReservationCoverage(
      request: io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.ReadOnly
  ] = ZIO.accessM(_.get.getReservationCoverage(request))
  def describeCostCategoryDefinition(
      request: io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeCostCategoryDefinition(request))
  def getAnomalyMonitors(
      request: io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getAnomalyMonitors(request))
  def getTags(
      request: io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest
  ): ZIO[
    CostExplorer,
    AwsError,
    io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getTags(request))
}
