package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiskResourceUtilization(
    diskReadOpsPerSecond: Option[GenericString] = None,
    diskWriteOpsPerSecond: Option[GenericString] = None,
    diskReadBytesPerSecond: Option[GenericString] = None,
    diskWriteBytesPerSecond: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization = {
    import DiskResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization
      .builder()
      .optionallyWith(
        diskReadOpsPerSecond.map(value => value: java.lang.String)
      )(_.diskReadOpsPerSecond)
      .optionallyWith(
        diskWriteOpsPerSecond.map(value => value: java.lang.String)
      )(_.diskWriteOpsPerSecond)
      .optionallyWith(
        diskReadBytesPerSecond.map(value => value: java.lang.String)
      )(_.diskReadBytesPerSecond)
      .optionallyWith(
        diskWriteBytesPerSecond.map(value => value: java.lang.String)
      )(_.diskWriteBytesPerSecond)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization
      .wrap(buildAwsValue())
}
object DiskResourceUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization =
      io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization(
        diskReadOpsPerSecondValue.map(value => value),
        diskWriteOpsPerSecondValue.map(value => value),
        diskReadBytesPerSecondValue.map(value => value),
        diskWriteBytesPerSecondValue.map(value => value)
      )
    def diskReadOpsPerSecondValue: Option[GenericString]
    def diskWriteOpsPerSecondValue: Option[GenericString]
    def diskReadBytesPerSecondValue: Option[GenericString]
    def diskWriteBytesPerSecondValue: Option[GenericString]
    def diskReadOpsPerSecond: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("diskReadOpsPerSecond", diskReadOpsPerSecondValue)
    def diskWriteOpsPerSecond: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("diskWriteOpsPerSecond", diskWriteOpsPerSecondValue)
    def diskReadBytesPerSecond: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("diskReadBytesPerSecond", diskReadBytesPerSecondValue)
    def diskWriteBytesPerSecond: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "diskWriteBytesPerSecond",
        diskWriteBytesPerSecondValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization
  ) extends io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization.ReadOnly {
    override def diskReadOpsPerSecondValue: Option[GenericString] = scala
      .Option(impl.diskReadOpsPerSecond())
      .map(value => value: GenericString)
    override def diskWriteOpsPerSecondValue: Option[GenericString] = scala
      .Option(impl.diskWriteOpsPerSecond())
      .map(value => value: GenericString)
    override def diskReadBytesPerSecondValue: Option[GenericString] = scala
      .Option(impl.diskReadBytesPerSecond())
      .map(value => value: GenericString)
    override def diskWriteBytesPerSecondValue: Option[GenericString] = scala
      .Option(impl.diskWriteBytesPerSecond())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization
  ): io.github.vigoo.zioaws.costexplorer.model.DiskResourceUtilization.ReadOnly =
    new Wrapper(impl)
}
