package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAnomalyMonitorRequest(
    monitorArn: GenericString,
    monitorName: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest = {
    import UpdateAnomalyMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest
      .builder()
      .monitorArn(monitorArn: java.lang.String)
      .optionallyWith(monitorName.map(value => value: java.lang.String))(
        _.monitorName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest
      .wrap(buildAwsValue())
}
object UpdateAnomalyMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest =
      io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest(
        monitorArnValue,
        monitorNameValue.map(value => value)
      )
    def monitorArnValue: GenericString
    def monitorNameValue: Option[GenericString]
    def monitorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(monitorArnValue)
    def monitorName: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("monitorName", monitorNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest.ReadOnly {
    override def monitorArnValue: GenericString =
      impl.monitorArn(): GenericString
    override def monitorNameValue: Option[GenericString] =
      scala.Option(impl.monitorName()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest
  ): io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalyMonitorRequest.ReadOnly =
    new Wrapper(impl)
}
